<?php
/**
*	此文件是流程模块【wordxie.文档协作】对应控制器接口文件。
*/ 
class mode_wordxieClassAction extends inputAction{
	
	/**
	*	重写函数：保存前处理，主要用于判断是否可以保存
	*	$table String 对应表名
	*	$arr Array 表单参数
	*	$id Int 对应表上记录Id 0添加时，大于0修改时
	*	$addbo Boolean 是否添加时
	*	return array('msg'=>'错误提示内容','rows'=> array()) 可返回空字符串，或者数组 rows 是可同时保存到数据库上数组
	*/
	protected function savebefore($table, $arr, $id, $addbo){
		
	}
	
	/**
	*	重写函数：保存后处理，主要保存其他表数据
	*	$table String 对应表名
	*	$arr Array 表单参数
	*	$id Int 对应表上记录Id
	*	$addbo Boolean 是否添加时
	*/	
	protected function saveafter($table, $arr, $id, $addbo){
		$wtype 		= $arr['wtype'];
		$filename 	= $arr['name'].'.'.$wtype;
		if(!$addbo){
			$ofrs = m('file')->getone($this->rs['fileid']);
			if(!$ofrs){
				$addbo=true;
			}else{
				$filepath = $ofrs['filepath'];
				if(substr($filepath,0,4)!='http' && !file_exists($filepath))$addbo=true;
			}
		}
		if($addbo){
			$filepath = ''.UPDIR.'/'.date('Y-m').'/workxie'.$id.'.'.$wtype.'';
			$this->rock->createtxt($filepath, base64_decode($this->creatework($wtype)));
			$fileid = m('file')->insert(array(
				'filename' => $filename,
				'fileext' => $wtype,
				'filesize' => 1000,
				'filetype' => 'application/msword',
				'filesizecn' => '10KB',
				'filepath' => $filepath,
				'optid' => $this->adminid,
				'optname' => $this->adminname,
				'adddt' => $this->rock->now,
				'ip' => $this->rock->ip,
				'web' => $this->rock->web,
				'mtype' => $table,
				'mknum' => $table,
				'mid' => $id,
			));
			m($table)->update(array(
				'fileid' => $fileid
			), $id);
		}else{
			$fileid = (int)arrvalue($this->rs, 'fileid','0');
			m('file')->update("`filename`='$filename'", "`id`='$fileid'");
		}
	}
	
	//上传保存好文件
	public function savefileAjax()
	{
		$fileid = (int)$this->get('upfileid');
		$id 	= (int)$this->get('id');
		return m('flow')->initflow('wordxie', $id, false)->savefile($fileid);
	}
	
	private function creatework($lx){
		$workarr = array(
			'docx' => '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',
			'xlsx' => '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',
			'pptx'=>'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'
		);
		return $workarr[$lx];
	}
}	
			