<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2020-4-2
 * Time: 0:17
 */

class openfkClassAction extends openapiAction
{
    public $data = [];
    public $subdata = [];
    public $model = null;
    public $ext = 'oa';

    public function initAction()
    {
        $data  = json_decode($_POST['data'],true);
        if(empty($data))  $this->showreturn([], $_POST['data'], '201');

        if(!empty($data['docnum'])) $this->data['docnum'] = $data['docnum']; //如果是编辑则携带编码
        $user = $this->getUser($data['uname']);

        if ($data['type'] == 1) {
            $this->model = 'fk';
            $this->data['applicationdpt'] = $data['dept'];
        };
        if ($data['type'] == 2) {
            $this->model = 'yfk';
            $this->data['application'] = $data['dept'];
        };

        //构建主表
        $this->data[$this->model.'name'] = $data['title'];
        $this->data['payee'] = $data['payee'];
        $this->data['paymentMethod'] = $data['payType'];
        $this->data['applicant'] = $user['name'];
        $this->data['fkorg'] = $data['payOrg'];
        $this->data['paymentBy'] = $data['remarks'];
        $this->data['fkinfo'] = $data['fkinfo'];
        $this->data['applydt'] = $this->data['optdt'] = $this->data['applydate'] = $data['date'] ?: date('Y-m-d');
        $this->data['uid']= $this->data['optid'] = $user['id'];
        $this->data['docnum'] = $this->data['docnum'] ?: $this->getDocNum();
        $this->data['status'] = 0;
        $this->subdata = $this->getSubData($data['details']);
        $this->data['amountOfThisPayment'] = $this->AmountSum();
    }

    //返回不存在的接口方法
    public function __call($name, $arguments)
    {
        $msg = $name . ' action not found';
        $this->showreturn([], $msg, '201');
    }

    //创建预付款单
    public function createAction()
    {
        $id = m($this->model)->insert($this->data);
        if ($id) {
            //插入子表数据
            $smode = m($this->model.'Detail');
            foreach ($this->subdata as $sub){
                $sub['mid'] = $id;
                $sub['comid'] = 1;
                $smode->insert($sub);
            }
            //启动流程
            $this->goflow($id);
            $this->showreturn(['numb' => $this->data['docnum'],'id'=>$id], '插入数据成功', '200');
        } else $this->showreturn([], '插入数据失败', '201');
    }

    public function updateAction(){
        $mid = $this->getIdByDocNum($this->data['docnum']);
        if(!$mid) $this->showreturn([], '修改数据失败,不匹配的数据记录', '201');

        $where = 'id='.$mid;
        unset($this->data['docnum']);
        $res = m($this->model)->update($this->data,$where);
        if(!$res) $this->showreturn([], '修改数据失败,数据字段异常或字段不匹配', '201');

        $smode = m($this->model.'Detail');
        //1.获取子表数据,子表数据必须要携带子表id
        //2.查询所有子表ID 如果子表ID存在于 记录中则是修改 否则是新增
        $scount = 0;
        foreach ($this->subdata as $k=>$sub){
            if(empty($sub['id'])){   //插入操作
                $sub['mid'] = $mid;
                $sub['comid'] = 1;
                $smode->insert($sub);
            } else {                //新增
                //如果已经存在的子表数据则修改
                if($smode->getone('id='.$sub['id'])){
                    $smode->update($sub,'id='.$sub['id']);
                } else {
                    $sub['mid'] = $mid;
                    $sub['comid'] = 1;
                    $smode->insert($sub);
                }
            }
            $scount++;
        }
        $this->showreturn([], '修改数据成功,子表数据成功修改'.$scount.'条记录', '200');
    }

    public function getUser($username)
    {
        $where = "email='".$username."@gonn.com.cn'";
        return $this->db->getone('oa_userinfo',$where);
    }

    public function getSubData($details=[]){
        $arr = [];
        foreach ($details as $k=>$d){
            if(!empty($d['id'])) $arr[$k]['id'] = $d['id'];
            $arr[$k]['charge_type'] = $d['chargeType'];
            $arr[$k]['charge_amount'] = $d['amount'];
            $arr[$k]['cbzx_code'] = $d['projectNumber'];
            $arr[$k]['contract_id'] = $d['contractNumber'];
            $arr[$k]['receipt_id'] = $d['receipt'];
        }
        return $arr;
    }
    //子表金额求和
    public function AmountSum(){
        $sum = 0;
        foreach ($this->subdata as $v){
            $sum += $v['charge_amount'];
        }
        return $sum;
    }

    private function getDocNum()
    {
        $pre = 'OA-FK-';
        if($this->model == 'yfk') $pre = 'OA-YFK-';
        $cext = $pre . date("Ymd");
        $where = "`docnum` like '%" . $cext . "%'";
        $mode = m($this->model);

        $data = $mode->getone($where, 'id,docnum', 'id desc');

        $num = '001';
        if ($data) {
            $num = (int)substr($data['docnum'], strlen($cext)) + 1;
            if (strlen($num) == 2) {
                $num = '0' . $num;
            } else if (strlen($num) == 1) {
                $num = '00' . $num;
            }
        }
        return $cext . $num;
    }

    private function getIdByDocNum($docnum){
        $data = m($this->model)->getone("`docnum`='".$docnum."'", 'id,docnum');
        return $data['id'] ?: 0;
    }

    private function goflow($id){
        $num = $this->ext.$this->model;
        $mode = m("flow:".$num);
        $mode->initdata($num);
        $mode->loaddata($id);
        $mode->submit();
    }
}