<?php
namespace app\station\controller\v1;
use app\station\model\BaseStationStatusAttributesModel;
use think\Controller;
/**
 * 基站状态属性API接口控制器
 * 负责基站状态属性的增删改查
 * Class Region
 * @package app\station\controller
 */
class BaseStationStatusAttributes extends Controller
{
    /**
 * 基站状态属性数据列表
 */
    public function baseStationStatusAttributes_list()
    {
    	  $model=new BaseStationStatusAttributesModel;
    	  $data=$model->selectBaseStationStatusAttributesList();
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','Query error please try again');
          }
    	  
    }
/**
 * 添加基站状态属性
 */
      public function baseStationStatusAttributes_add()
    {
        $file =$this->request->file('image');
        if($file){
            $info = $file->move('../public/uploads/attributes');
            $parem=$this->request->post();
            $getSaveName=str_replace("\\","/",$info->getSaveName());
        }else{
              return jsonSucc('200002','没有文件上传');
        }
    	if($parem){
         $parem['path']='/uploads/attributes/'.$getSaveName;
    	 $model=new BaseStationStatusAttributesModel;
    	 $result=$model->insertBaseStationStatusAttributes($parem);
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 修改基站状态属性
 */
     public function baseStationStatusAttributes_edit()
    {
      $file =$this->request->file('image');
      if($file){
        $info = $file->move('../public/uploads/attributes');
        $parem=$this->request->post();
        $getSaveName=str_replace("\\","/",$info->getSaveName());
        $parem['path']='/uploads/attributes/'.$getSaveName;
      }
    	if($parem){
         if(empty($parem['attribute_id'])){
            return jsonSucc('200001','id参数不合法，无法修改');
         }

    	 $model=new BaseStationStatusAttributesModel;
    	 $result=$model->updBaseStationStatusAttributes($parem);
    	 if($result['code']==10001){
    	 	return jsonSucc('200001','id不存在');
    	 }
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 获取修改基站状态属性数据
 */
    public function getOnebaseStationStatusAttributes()
    {
    	$parem=$this->request->post();
    	 $model=new BaseStationStatusAttributesModel;
    	 $result=$model->getOneBaseStationStatusAttributes($parem);
    	  if($result['code']==10001){
    	  	return jsonSucc('200001','暂无找到id');
    	  }else{
    	  	 return jsonSucc('','suceess',$result['data']);
    	  }
    	 
    }
/**
 * 删除基站状态属性数据（软删除）
 */
     public function baseStationStatusAttributes_del()
    { 
      $parem=$this->request->post();
    	if($parem){
    	 $model=new BaseStationStatusAttributesModel;
    	 $result=$model->delBaseStationStatusAttributes($parem);
    	 switch ($result['code']) {
    	 	case '10001':
    	 		 return jsonSucc('200001','暂无找到id');
    	 		break;
    	 	
    	 	case '200':
    	 		 return jsonSucc('200','suceess');
    	 		break;

    	 	default:
    	 		return jsonSucc('1000001','error');
    	 		break;
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
}