<?php

namespace app\admin\model;

use think\Exception;
use think\model\concern\SoftDelete;

class PermissionModel extends BaseModel
{
    use SoftDelete;
    protected $deleteTime = 'delete_time';
    protected $table = 'permission';

    private $fields = 'id,title,pid,model_name,controller_name,method_name,params,is_nav,sort,status,update_time';
    private $ids = [];

    private function getPermissionTree($fields = '',$isNav = false)
    {
        if($fields != ''){
            $this->fields = $fields;
        }
        $map = [];
        if($isNav){
            $map = ['is_nav'=>1];
        }
        $data = $this->where($map)->field($this->fields)->select()->order('id asc,sort desc')->toArray();
        if(empty($data) || false == $data){
            throw new Exception('没有权限数据!');
        }
        $data = getTree($data);
        foreach ($data as &$value){
            $value['name'] = str_repeat('--', $value['level']).$value['title'];
        }

        return $data;
    }

    public function getPermissionTreeAll(){
        return $this->getPermissionTree();
    }

    public function getPermissionTreePart($fields = 'id,pid,title'){
        return $this->getPermissionTree($fields);
    }

    public function getPermissionTreeNav($fields='id,pid,title,is_nav'){
        return $this->getPermissionTree($fields,true);
    }

    public function getIds($id=0){
        //通过递归循环取出所有id数据
        //循环取出所有pid=id的ids
        $this->ids[] = $id;
        $this->getModelIds($id);
        return $this->ids;
    }

    public function delRowByIds($id,$type=true){
       $ids = $this->getIds($id);
       return self::destroy($ids,$type);
    }
    /**
     * 获取包含所有子节点的ID数组
     * @param $pid
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    private function getModelIds($pid){
        $data = $this->field('id,pid')->where(['pid'=>$pid])->select();
        if($data){
            foreach ($data as $value){
                $this->ids[] = $value['id'];
                $this->getModelIds($value['id']);
            }
        } else {
            return ;
        }
    }

    public function getFeaturePermissionList(){

        $permissionList = [];
        $oneLevelPermission = $this->field('id,title')->where(['pid'=>0])->select()->toArray();

        foreach ($oneLevelPermission as $value){
            $twoLevelPermission = $this->field('id,title')->where(['pid'=>$value['id']])->select()->toArray();
            $permissionList[] = [
                'parent'=> $value,
                'child'=>$twoLevelPermission
            ];
        }
        return $permissionList;
    }

    public function getNodesTree($fields = 'id,pid,title',$isNav = false){
        if($fields != ''){
            $this->fields = $fields;
        }
        $data = $this->field($this->fields)->select()->order('id asc')->toArray();
        if(empty($data) || false == $data){
            throw new Exception('没有权限数据!');
        }
        $data = getNodesTree($data);
//        return json_encode((object)$data);
        return $data;
    }


    public  function getPermissionstatusById($id){
        $Permissions = $this->field('status')->where(['id'=>$id])->find()->toArray();
        return $Permissions;
    }
    public  function setPermissionStatus($id,$status){
        $Permissions = $this->allowField(true)->save(['status'=>$status],['id' => $id]);
        return $Permissions;
    }
}