<?php


namespace app\admin\model;


class PaymentModel extends BaseModel
{
    protected $table = 'payment';

    public function setPayDateAttr($value){
        return strtotime($value);
    }

    public function getPayDateAttr($value){
        return date('Y-m-d',$value);
    }

    public function photo(){
        return $this->belongsTo('ReceiptModel','invoice_fid');
    }

    public static function getPaymentByCpId($id){
        $payment = self::with('photo')->where(['cp_id'=>$id])->find();
        if($payment && isset($payment->photo)){
            $payment->photo_src = ltrim($payment->photo->src,'.');
        }
        return $payment;
    }
}