<?php


namespace app\station\controller;

use think\Controller;
use think\Exception;
use app\station\model\Station as StationModel;

/**
 * 基站查询
 * Class Search
 * @package app\station\controller
 */
class Search extends Controller
{
    /**
     * 根据提供的字段查询基站信息
     * @param string $tag 查询条件
     * @param string $val 字段值
     * @param string $field 数据字段
     * @return string
     * @throws Exception
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function searchByTagName($tag='',$val='',$area='',$field='station_id,station_name,proj_number,station_sp_code')
    {
        if(empty($tag) || empty($val)){
            throw new Exception('searchByTagName方法的请求参数不能为空');
        }
        $map1 = [$tag,'=',$val];
        $map2 = ['station_id','in',$area];

        if($area != ''){
            $stations = StationModel::field($field)->where([$map1,$map2])->select()->toArray();  //精确查找，然后模糊查询
            if(!$stations){
                $stations = StationModel::field($field)->where([[$tag,'LIKE',"%$val%"],$map2])->select()->toArray();
            }
        } else {
            $stations = StationModel::field($field)->where($map1)->select()->toArray();  //精确查找，然后模糊查询
            if(!$stations){
                $stations = StationModel::field($field)->where($tag,'LIKE',"%$val%")->select()->toArray();
            }
        }

        return $stations ?: '';
    }
}