<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-7-21
 * Time: 19:48
 */

namespace app\impexp\controller;

use think\Exception;
use think\facade\Env;


/**
 * 导入导出模块基类 获取上传文件完整路径名
 * Class Base
 * @package app\impexp\controller
 */
class Base
{
    protected $root_path;
    protected $file_path;
    protected $file_name;

    public function __construct(){
        $this->root_path = Env::get('root_path');
        $this->file_path = $this->root_path.'uploads/xls';
    }

    public function upload($formFile){
        $file = request()->file($formFile ?: 'file');

        $info = $file->validate(['size'=>20480000,'ext'=>'xls,xlsx'])->move($this->file_path);

        if($info){
            return str_replace('\\','/',$this->file_path.DIRECTORY_SEPARATOR.$info->getSaveName());
        } else {
            throw new Exception('文件上传失败 999'.$file->getError());
        }
    }

    /**
     * 获取完整上传文件路径
     * @param string $formFile
     * @return mixed
     * @throws Exception
     */
    public function getFile($formFile = ''){
        return $this->upload($formFile);
    }
}