<?php
namespace app\em\validate;
use think\Validate;

class EmAddRuleValidate extends Validate
{
    protected $rule = [
        //rule
        //缴费
        'charge_type' => 'require',
        'pay_price' => 'require',
        'pay_cycle' => 'require',
        'pay_protocol_numb' =>'require',
        //包年包月
        'cycle_start_time' => 'require',
        'cycle_finish_time' => 'require',
        'cycle_amount' => 'require',
        'cycle_cert' => 'require',

        //结算信息
        'settle_price' => 'require',
        'settle_protocol_numb' => 'require',
        'settle_type' => 'require',
        'pricing_type' => 'require',
    ];

    protected $message = [
        'init_numb.require' => '请填写初始读数',
        'init_amount.require' => '请填写初始读数',
        'init_date.require' => '请填写首次查表日期',
        'photo_id.require' => '请上传电表照片',
        'staff_id.require' => '请选择业务员',

        'charge_type.require' => '请填写计量模式',
        'pay_price.require' => '请填写缴费单价',
        'pay_cycle.require' => '请填写缴费周期',
        'pay_protocol_numb.require' => '请填写缴费协议编号',

        'cycle_start_time.require' => '请填写起始承包日期',
        'cycle_finish_time.require' => '请填写结束承包日期',
        'cycle_amount.require' => '请填写承包金额',
        'cycle_cert.require' => '请填写承包凭证编号',

        'settle_price.require' => '请填写结算单价',
        'settle_protocol_numb.require' => '请填写结算协议编号',
        'settle_type.require' => '请选择结算模式',
    ];

    protected $scene = [
        //电表缴费规则 读表模式
        's1' => 'pay_price,pay_cycle,pay_protocol_numb,
                    settle_price,settle_protocol_numb,settle_type',

        //电表缴费规则 包年包月
        's2' => 'pay_protocol_numb,
                    cycle_start_time,cycle_finish_time,cycle_amount,
                    settle_price,settle_protocol_numb,settle_type',

    ];
}