<?php


namespace app\admin\validate;


use think\Validate;

class PaymentAddValidate extends Validate
{
    protected $rule = [
        'cp_id' => 'require',
        'pay_way' => 'require',
        'check_numb' => 'require',
        'pay_date' => 'require|date',
        'invoice_numb' => 'require',
        'invoice_fid' => 'require',
        'invoice_type' => 'require',
        'tax_rate' => 'require|number|max:2',
        'tax_amount' => 'require',
        'pay_sid'=>'require'
    ];

    protected $message = [
        'cp_id.require' => '系统错误,请联系管理员,不存在的抄表单ID',
        'pay_way.require' => '请选择支付方式',
        'check_numb.require'=> '请填写支票账号',
        'pay_date.require' => '请选择缴费日期',
        'pay_date.date' => '缴费日期无效',
        'invoice_numb.require' => '请填写发票号码',
        'invoice_fid.require' => '请上传发票附件',
        'invoice_type.require' => '请选择发票类型',
        'tax_rate.require' => '请填写税点',
        'tax_rate.number' => '税点只能填写1-2位数字',
        'tax_rate.max:2' => '税点只能是两位数字',
        'tax_amount.require' =>'请填写税额',
        'pay_sid.require' => '请选择缴费人员',
    ];

    protected $scene = [
        'checkNumb' => 'cp_id,pay_way,check_numb,pay_date,invoice_numb,invoice_fid,invoice_type,tax_rate,tax_amount,pay_sid',
        'cash' => 'cp_id,pay_way,pay_date,invoice_numb,invoice_fid,invoice_type,tax_rate,tax_amount,pay_sid',
    ];
}