<?php 
namespace app\station\model;
use think\Model;
use think\model\concern\SoftDelete;
class DemandSourceModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键id
    protected $pk = 'sources_id';
    //数据表
    protected $table = 'demand_source';

    public  function selectDemandSource(){
     $data = $this->field("sources_id,sources_name,sources_state")->select()->toarray();
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }
    public function insertDemandSource($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }

    public function updDemandSource($parem){
        try {
           $data=$this->allowField(true)->where(['sources_id' => $parem['sources_id']])->find();
           if($data){
                 $result=$this->allowField(true)->save($parem,['sources_id' => $parem['sources_id']]);
                if($result){
                     return ['code' => 200, 'data' => '', 'message' => '修改成功'];
                }else{
                     return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
           }else{
               return ['code' => 10001, 'data' => '', 'message' => '没有id'];
           }
           
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
      public  function updselectDemandSource($parem){
         $data = $this->field("sources_id,sources_name,sources_state")->where($parem)->find();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到id相关信息'];
         }
        }


    public function delDemandSource($parem){
         try {
            $data=$this->allowField(true)->where($parem)->find();
            if($data){
                $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            }else{
               return ['code' => 10001, 'data' => '', 'message' => $this->getError()];
            }
          
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}