<?php
namespace app\station\controller\v1;
use app\station\model\BaseStationModel;
use app\station\model\DepartpermissionModel;
use think\Controller;
use think\Request;
use think\db;
/**
 * 基站数据API接口控制器
 * 负责基站数据的增删改查
 * Class BaseStation
 * @package app\station\controller
 */
class BaseStation extends Controller
{
    /**
 * 基站数据数据列表
 */
    public function baseStation_list(Request $request)
    {
       if($request->isGet()){
          $model=new BaseStationModel;
          $user_id = $this->request->get('user_id');
         if($user_id){
          $map=[];
          $permission=db::name('permission_data')->field('permission_ids')->where(['s_id'=>$user_id])->find();
              $arr= json_decode($permission['permission_ids'],true);
              if($arr['department_id']){
                    $department_ids=strpos($arr['department_id'],',');
                    if($department_ids===false){
                        $map[]=['department_id','=', $arr['department_id']];
                    }else{
                        $map[]=['department_id','in',$arr['department_id']];
                    }
                }
                if($arr['region_id']){
                    $area_ids=strpos($arr['region_id'],',');
                    if($area_ids===false){
                        $map[]=['area_id','=', $arr['region_id']];
                    }else{
                        $map[]=['area_id','in',$arr['region_id']];
                    }
                }
                if($arr['business_id']){
                    $business_ids=strpos($arr['business_id'],',');
                    if($business_ids===false){
                        $map[]=['business_line_id','=', $arr['business_id']];
                     }else{
                        $map[]=['business_line_id','in',$arr['business_id']];
                     }
                }
                 //如果数据规则表不存在数据信息 ，默认返回此用户的部门id
                if(!$map){
                 $staff = db::name('staff')->field('d_id')->where(['id'=>$user_id])->find();

                 if($staff && $staff['d_id']!==0){

                    $map[]=['department_id','=',$staff['d_id']];

                 }
                }
        }
          $original_sp_id = $this->request->get('original_sp_id');
          if($original_sp_id){
               $map[]=['original_sp_id','=',$original_sp_id];
          }
          $area_id = $this->request->get('area_id');
          if($area_id){
             $map[]=['area_id','=',$area_id];
          }
          $base_station_state = $this->request->get('base_station_state');
          if($base_station_state){
             $map[]=['base_station_state','=',$base_station_state];
          }
           $station_name = $this->request->get('station_name');
          if($station_name){
             $map[]=['station_name','like',"%$station_name%"];
          }
             $station_sp_code = $this->request->get('station_sp_code');
          if($station_sp_code){
             $map[]=['station_sp_code','like',"%$station_sp_code%"];
          }
             $proj_number = $this->request->get('proj_number');
          if($proj_number){
             $map[]=['proj_number','like',"%$proj_number%"];
          }
          $map[] = ['status','=',1];
          $page =  $this->request->get('page') ?  $this->request->get('page'):1;
          $page_size =  $this->request->get('page_size')? $this->request->get('page_size'):10;
          if($page_size>100){
              return jsonSucc('20065','page_size超出范围限制');
          }
          $sort = $this->request->get('sort')? $this->request->get('sort'): 'desc';


          $data=$model->selectBaseStationList($map,$page,$page_size,$sort);
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data'],$data['total_count'],$data['total_page'],$data['current_page']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','not data');
          }
        }else{
            return jsonSucc('20064','not GET');
        }
    }
/**
 * 添加基站数据
 */
      public function baseStation_add(Request $request)
    {   
        $parem=$this->request->post();
        if($parem){
         $model=new BaseStationModel;
         $result=$model->insertBaseStation($parem);
         if($result['code']==200){
           return jsonSucc('200','suceess');
         }else{
           return jsonSucc('200001','error');
         }
        }else{
            return jsonSucc('1000001','error');
        }
    }
/**
 * 修改基站数据
 */
     public function baseStation_edit(Request $request)
    {    
          // $file =$this->request->file('essential_factor_url');
          // $route_image =$this->request->file('route_image');
          // if($file){
          //   $info = $file->move('../public/uploads/base');
          //   $getSaveName=str_replace("\\","/",$info->getSaveName());
          //   $parem['essential_factor_url']='/uploads/base/'.$getSaveName;
          // }
          // if($route_image){
          //   $info = $file->move('../public/uploads/base');
          //   $getSaveName=str_replace("\\","/",$info->getSaveName());
          //   $parem['route_image']='/uploads/base/'.$getSaveName;
          // }
         $parem=$this->request->post();

        if($parem){
         if(empty($parem['station_id'])){
            return jsonSucc('200001','参数不合法，无法修改');
         }
         $model=new BaseStationModel;
         $result=$model->updBaseStation($parem);
         if($result['code']==10001){
            return jsonSucc('200001','station_id不存在');
         }
         if($result['code']==200){
           return jsonSucc('200','suceess');
         }else{
           return jsonSucc('200001','error');
         }
        }else{
            return jsonSucc('1000001','error');
        }
    }
/**
 * 获取修改基站数据数据
 */
    public function getOneBaseStation()
    {
        $parem=$this->request->post();
         $model=new BaseStationModel;
         $result=$model->getOneBaseStation($parem);
            
          if($result['code']==10001){
            return jsonSucc('200001','暂无找到id');
          }else{
             return jsonSucc('','suceess',$result['data']);
          }
         
    }
//获取地图
       public function getbaseMap(Request $request)
    {
        $parem=$this->request->post();
         $model=new BaseStationModel;
         $result=$model->getMapBaseStation($parem);

          if($result['code']==10001){
            return jsonSucc('200001','暂无找到id');
          }else{
             return jsonSucc('','suceess',$result['data']);
          }
         
    }
    //获取地图
       public function getbaseMapList(Request $request)
    {
          $model=new BaseStationModel;
          $user_id = $this->request->get('user_id');
           if($user_id){
          $permission=db::name('permission_data')->field('permission_ids')->where(['s_id'=>$user_id])->find();
              $arr= json_decode($permission['permission_ids'],true);
              if($arr['department_id']){
                    $department_ids=strpos($arr['department_id'],',');
                    if($department_ids===false){
                        $map[]=['department_id','=', $arr['department_id']];
                    }else{
                        $map[]=['department_id','in',$arr['department_id']];
                    }
                }
                if($arr['region_id']){
                    $area_ids=strpos($arr['region_id'],',');
                    if($area_ids===false){
                        $map[]=['area_id','=', $arr['region_id']];
                    }else{
                        $map[]=['area_id','in',$arr['region_id']];
                    }
                }
                if($arr['business_id']){
                    $business_ids=strpos($arr['business_id'],',');
                    if($business_ids===false){
                        $map[]=['business_line_id','=', $arr['business_id']];
                     }else{
                        $map[]=['business_line_id','in',$arr['business_id']];
                     }
                }
                 //如果数据规则表不存在数据信息 ，默认返回此用户的部门id
                if(!$map){
                 $staff = db::name('staff')->field('d_id')->where(['id'=>$user_id])->find();
                 if($staff && $staff['d_id']!==0){
                    $map[]=['department_id','=',$staff['d_id']];
                 }
                }
        }
          $original_sp_id = $this->request->get('original_sp_id');
          if($original_sp_id){
               $map[]=['original_sp_id','=',$original_sp_id];
          }
          $area_id = $this->request->get('area_id');
          if($area_id){
             $map[]=['area_id','=',$area_id];
          }
          $base_station_state = $this->request->get('base_station_state');
          if($base_station_state){
             $map[]=['base_station_state','=',$base_station_state];
          }
           $station_name = $this->request->get('station_name');
          if($station_name){
             $map[]=['station_name','like',"%$station_name%"];
          }
             $station_sp_code = $this->request->get('station_sp_code');
          if($station_sp_code){
             $map[]=['station_sp_code','like',"%$station_sp_code%"];
          }
             $proj_number = $this->request->get('proj_number');
          if($proj_number){
             $map[]=['proj_number','like',"%$proj_number%"];
          }

          $map[] = ['status','=',1];
          $data=$model->getAllMapList($map);
                  $lats = $lons = array();
                  foreach ($data['data'] as $key => $value) {
                    if($value['latitude']){
                  array_push($lats, $value['latitude']);
                  array_push($lons, $value['longitude']);
                  }
                   }
                  $minlat = min($lats);
                  $maxlat = max($lats);
                  $minlon = min($lons);
                  $maxlon = max($lons);

                  $zpoint = [
                  'minLat'=>$minlat,
                  'maxLat'=>$maxlat,
                  'minLng'=>$minlon,
                  'maxLng'=>$maxlon
                  ];
                  $lat = $maxlat - (($maxlat - $minlat) / 2);
                  $lng = $maxlon - (($maxlon - $minlon) / 2);

                  $oPoint=array("latitude" => $lat, "longitude" => $lng);
                  $data['data']['datacount'] = $data['datacount'];
                  $data['data']['counts'] = $data['counts'];
                  $data['data']['oPoint'] = $oPoint;
                  $data['data']['zPoint'] = $zpoint;
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','not data');
          }
         
    }
    public function base_export(Request $request)
    {
       if($request->isGet()){
          $model=new BaseStationModel;
          $user_id = $this->request->get('user_id');
          if($user_id){
          $permission=db::name('permission_data')->field('permission_ids')->where(['s_id'=>$user_id])->find();
              $arr= json_decode($permission['permission_ids'],true);
              if($arr['department_id']){
                    $department_ids=strpos($arr['department_id'],',');
                    if($department_ids===false){
                        $map[]=['department_id','=', $arr['department_id']];
                    }else{
                        $map[]=['department_id','in',$arr['department_id']];
                    }
                }
                if($arr['region_id']){
                    $area_ids=strpos($arr['region_id'],',');
                    if($area_ids===false){
                        $map[]=['area_id','=', $arr['region_id']];
                    }else{
                        $map[]=['area_id','in',$arr['region_id']];
                    }
                }
                if($arr['business_id']){
                    $business_ids=strpos($arr['business_id'],',');
                    if($business_ids===false){
                        $map[]=['business_line_id','=', $arr['business_id']];
                     }else{
                        $map[]=['business_line_id','in',$arr['business_id']];
                     }
                }
                 //如果数据规则表不存在数据信息 ，默认返回此用户的部门id
                if(!$map){
                 $staff = db::name('staff')->field('d_id')->where(['id'=>$user_id])->find();
                 if($staff && $staff['d_id']!==0){
                    $map[]=['department_id','=',$staff['d_id']];
                 }
                }
        }
          $original_sp_id = $this->request->get('original_sp_id');
          if($original_sp_id){
               $map[]=['original_sp_id','=',$original_sp_id];
          }
          $area_id = $this->request->get('area_id');
          if($area_id){
             $map[]=['area_id','=',$area_id];
          }
          $base_station_state = $this->request->get('base_station_state');
          if($base_station_state){
             $map[]=['base_station_state','=',$base_station_state];
          }
           $station_name = $this->request->get('station_name');
          if($station_name){
             $map[]=['station_name','like',"%$station_name%"];
          }
             $station_sp_code = $this->request->get('station_sp_code');
          if($station_sp_code){
             $map[]=['station_sp_code','like',"%$station_sp_code%"];
          }
             $proj_number = $this->request->get('proj_number');
          if($proj_number){
             $map[]=['proj_number','like',"%$proj_number%"];
          }
          $map[] = ['status','=',1];
          $data=$model->getAllBaseStation($map);
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','not data');
          }
        }else{
            return jsonSucc('20064','not GET');
        }
    }
/**
 * 删除基站数据数据（软删除）
 */
     public function baseStation_del()
    { 
      $parem=$this->request->post();
        if($parem){
         $model=new BaseStationModel;
         $result=$model->baseStation_del($parem);
         switch ($result['code']) {
            case '10001':
                 return jsonSucc('200001','暂无找到id');
                break;
            
            case '200':
                 return jsonSucc('200','suceess');
                break;

            default:
                return jsonSucc('1000001','error');
                break;
         }
        }else{
            return jsonSucc('1000001','error');
        }
    }
}
