<?php
namespace app\em\validate;
use think\Validate;

class AddReceiptValidate extends Validate
{
    protected $rule = [
        'type'=>'require',
        'numb'=>'require',
        'file_id'=>'require',
        'amount'=>'require|checkData',
        'tax_rate'=>'require|number|max:2'
    ];

    protected $message = [
        'type.require'=>'请选择发票类型',
        'numb.require'=>'请填写发票号',
        'file_id.require'=>'请上传附件',
        'amount.require'=>'请填写发票金额',
        'tax_rate.require'=>'请填写税率',
        'tax_rate.number'=>'税率只能填写数字',
        'tax_rate.max'=>'税率最多只能是两位数',
    ];

    protected function checkData($value,$rule,$data=[]){
        if($data['balance'] == 0){
            return true;
        }
        if($value > $data['balance']){
            return '发票金额不能大于应缴金额';
        } else {
            return true;
        }
    }
}