<?php
namespace app\em\validate;
use think\Validate;
class AddPaymentValidate extends Validate
{
    protected $rule = [
        'em_id' => 'require',
        'payment_id' => 'require',
        'pay_date' => 'require',
        'staff_id' => 'require',
        'amount' => 'require'
    ];

    protected $message = [
        'em_id.require' => '未关联电表ID,无法缴费',
        'payment_id.require' => '未创建缴费单ID,无法缴费',
        'amount.require' => '未填写缴费金额',
        'pay_date.require' => '请选择缴费日期',
        'staff_id.require' => '请选择缴费业务员'
    ];

    protected $scene = [
      's1' => 'em_id,payment_id,pay_date,staff_id,amount',
      's2' => 'em_id,amount,staff_id'
    ];
}