<?php
namespace app\em\model;

class Station extends Base
{
    protected $table = 'station_info';

    /**
     * 获取基站基本信息
     * @param $id
     * @return array|\PDOStatement|string|\think\Model|null
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public static function getBaseInfoById($id){
        $station_info = \app\station\model\Station
            ::where('station_id','=',$id)
            ->field('station_id,station_name,station_sp_code,proj_number')
            ->field('region.region_name as area_name')
            ->field('operator.operator_name')
            ->leftJoin(['operator'],'operator.operator_id = original_sp_id')
            ->leftJoin(['region'],'region.id=area_id')
            ->find();
        return $station_info;
    }
}