<?php
namespace app\em\controller;
use app\admin\controller\Base;
use app\em\model\EmAccount;

/**
 * 电表账户
 * Class Acount
 * @package app\em\controller
 */
class Account extends Base
{
    //账户初始化
    private function init($em_id){
        $accountModel = new EmAccount();
        $accountModel->account_id = $this->createAId();
        $accountModel->em_id = $em_id;
        $accountModel->amount = 0;
        $accountModel->save();
        return $accountModel;
    }

    /**
     * 更新账户额度
     * @param $em_id 账户电表ID
     * @param $amount 账户额度
     * @param $action 如果是0 表示欠账,如果是1,则代表充值
     */
    public function updateAmount($em_id,$amount,$action=0){
        $accountModel = $this->getAccount($em_id);
        if($action == 0){
            $tempAmount = $accountModel->amount - $amount;
        } else {
            $tempAmount = $accountModel->amount + $amount;
        }
        $accountModel->amount = (string)$tempAmount;
        $accountModel->save();
    }

    //获取账户对象
    public function getAccount($em_id){
        if($this->check($em_id) == false){
            return $this->init($em_id);
        }
        $accountModel = EmAccount::where('em_id','=',$em_id)->find();
        return $accountModel;
    }

    //创建凭证id
    private function createAId(){
        $inv = EmAccount::field('id')->order('id desc,create_time desc')->find();
        if(!$inv) $id = 1;
        else $id = $inv->id + 1;
        return "ZH".date('Ymd').zero($id);
    }

    //检测是否已经生成账户
    private function check($em_id){
        $accountModel = EmAccount::where('em_id','=',$em_id)->find();
        if(!$accountModel) return false;
        else return true;
    }

    //读取账户ID
    public function getAccountId($em_id){
        $account = $this->getAccount($em_id);
        return $account->account_id;
    }

    //创建账户
    public function createAccount($em_id){
        if($this->check($em_id) == false){
            return $this->init($em_id);
        }
    }

    /**
     * 更新余额
     * @param $account_id
     * @param $amount
     * @return mixed
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function upAmount($account_id,$amount,$action = 'payment'){
        $account = EmAccount::where('account_id','=',$account_id)->find();

        if($action == 'payment'){
            $account->amount += $amount;
        } else {
            $account->amount -= $amount;
        }
        return $account->save();
    }
}