<?php


namespace app\api\validate;


class TokenValidate extends BaseValidate
{
    protected $rule = [
        //token长度
        'token' => 'require|length:32',

        //生成token的参数
        'app_id' => 'require',
        'sign' => 'require',
        'timestamp' => 'require|length:10,11'
    ];

    protected $scene = [
        'create' => 'app_id,sign,timestamp',
        'check' => 'token'
    ];
}