<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-28
 * Time: 0:39
 */

namespace app\admin\model;


class StatementModel extends BaseModel
{
    protected $table = 'statement';

    public static function getLastPowerOver($em_id,$id){

        $order = OrderModel::order('create_time desc')->where('em_id','=',$em_id)->select();
        //默认第一次
        if(!$order){
            $em = ElectricMeter::find($em_id);
            return $em->init_amount;
        }

        //存在抄表记录的 则找上一次的
        $orderArr = $order->toArray();
        $count = count($orderArr);
        $last = $orderArr[$count - 1];
        if($last['cp_id'] == $id){
            $em = ElectricMeter::find($em_id);
            return $em->init_amount;
        }

        //找出相同em_id 下面的statement id
        $ids =  [];
        foreach ($orderArr as $item){
            $ids[] = $item['id'];
        }
        $map[] = ['copy_id','<',$id];
        $map[] = ['id','in',$ids];
        $statement = StatementModel::where($map)->order('id desc')->find();

        if($statement) return $statement->power_over;

       foreach ($orderArr as $value){
           if($value['statement_id'] != '') {
               $statement = StatementModel::order('create_time desc')->find($value['statement_id']);
               $power_over = $statement->power_over;
               break;
           }
       }

       return $power_over;
    }

    public static function getLastRecharge($em_id,$id){

        //否则
        $order = OrderModel::order('create_time desc')->where('em_id','=',$em_id)->select();
        //默认第一次
        if(!$order) return 0;

        //存在抄表记录的 则找上一次的
        $orderArr = $order->toArray();
        $count = count($orderArr);
        $last = $orderArr[$count - 1];
        if($last['cp_id'] == $id){
            return 0;
        }

        $ids =  [];
        foreach ($orderArr as $item){
            $ids[] = $item['id'];
        }
        $map[] = ['copy_id','<',$id];
        $map[] = ['id','in',$ids];
        $statement = StatementModel::where($map)->order('id desc')->find();

        if($statement) return $statement->recharge;

        foreach ($orderArr as $value){
            if($value['statement_id'] != '') {
                $statement = StatementModel::order('create_time desc')->find($value['statement_id']);
                $recharge = $statement->recharge;
                break;
            }
        }
        return $recharge;
    }

    public static function getFinancPay($id){
        $statement = self::get(['copy_id'=>$id]);
        if(!$statement) return '';
        return $statement->financ_pay ?: 0;
    }

    public function photo(){
        return $this->belongsTo('ReceiptModel','photo_id');
    }

    public static function getStatementByCpId($id){
        $statement = self::with('photo')->where(['copy_id'=>$id])->order('create_time desc')->find();
        if($statement && isset($statement->photo)){
            $statement->photo_src = ltrim($statement->photo->src,'.');
        }
        return $statement;
    }
}