<?php
namespace app\admin\controller;

use app\admin\model\PermissionModel;
use app\admin\model\RoleModel;
use app\admin\model\RolePermissionModel;
use app\admin\validate\RoleValidate;
use think\Request;

/**
 * 角色控制器
 * 负责角色的增删改查
 * Class Role
 * @package app\admin\controller
 */
class Role extends Base
{
    public function index(RoleModel $role)
    {
        $roles = $role->select();
        $this->assign('data',$roles);
        return $this->fetch('index');
    }

    public function create(PermissionModel $permission)
    {
        $PermissionData = $permission->getFeaturePermissionList();
        $this->assign('permissionData',$PermissionData);
        return $this->fetch('add');
    }

    public function store(Request $request,RoleValidate $validate)
    {
        if(!$validate->check($request->post())){
            return jsonErr($validate->getError());
        }

        $role = new RoleModel();
        if($role->allowField(['title','remark'])->save($request->post())){
            $result = $this->addRulePermission($role->id,$request->post('permission'));
            if($result){
                return jsonSuc('添加角色成功');
            } else {
                return jsonErr('添加角色权限失败');
            }
        } else {
            return jsonErr('添加角色失败');
        }
    }

    public function edit($id)
    {
        $role = RoleModel::get($id)->toArray();
        $permissionOwn = RolePermissionModel::where(['r_id'=>$id])->find();
        $nodes = (new PermissionModel)->getNodesTree();
        $permissions = $permissionOwn['p_ids'];
        $permissions = explode(',',$permissions);

        $this->assign('permissions',$permissions);
        $this->assign('data',$role);
        $this->assign('nodes',$nodes);
         return $this->fetch('edit');
    }

    public function update(Request $request,RoleValidate $validate){
        $id = $request->post('id');
        $role = RoleModel::get($id);

        //检测是否更改了角色名称
        if($role->title != $request->post('title')){
            if(!$validate->check($request->post())){
                return jsonErr($validate->getError());
            }
        }

        $role->title = $request->post('title');
        $role->remark = $request->post('remark');
        if($role->save()){
            $result = $this->addRulePermission($role->id,$request->post('permission'));
            if($result){
                return jsonSuc('更新角色成功');
            } else {
                return jsonErr('更新角色成功，但改变权限失败');
            }
        } else {
            return jsonErr('更新角色失败，请重试');
        }
    }

    public function delete(Request $request,RoleModel $role){
        $id = $request->post('id');
        if($role->delRowById($id)){
            return jsonSuc('删除数据成功');
        } else {
            return jsonErr('删除数据失败');
        }
    }

    private function addRulePermission($id, $permission = []) {
        $RolePermission = new RolePermissionModel;
        $model =  $RolePermission->where(['r_id'=>$id])->find();
        $permissions = implode(',',$permission);

        if($model){
            $model->p_ids = $permissions;
            return $model->save();
        } else {
            $RolePermission->r_id = $id;
            $RolePermission->p_ids = $permissions;
            return $RolePermission->save();
        }
    }
}