<?php
namespace app\em\model;
use app\admin\model\DepartmentModel;
use app\admin\model\StaffModel;
use think\Session;

class Staff extends Base
{
    protected $table = 'staff';

    public function getStaffs($is_admin=false,$staff_id=''){
        if($is_admin){
            $staffs = StaffModel::field('id,name')->select()->toArray();
        } else {
            if($staff_id == ''){
                $user  =  \think\facade\Session::get('user');
                $staff = StaffModel::where('id','=',$user['user_id'])->find();
            } else {
                $staff = StaffModel::where('id','=',$staff_id)->find();
            }
            $dIds = (new DepartmentModel)->getNodeIds($staff['d_id']);
            $staffs = StaffModel::field('id,name')->where('d_id','in',$dIds)->select()->toArray();
        }
        return $staffs;
    }
}