<?php
namespace app\em\model;

class EmPayment extends Base
{
    protected $table = 'em_payment';

    public function getPayDateAttr($val){
        return date('Y-m-d H:i:s',$val);
    }
    public function setPayDateAttr($val){
        return strtotime($val);
    }

    //缴费单+search
    public function getPaymentList($map,$Nowpage,$limits){

        //先找到账单
        $data = self::alias('pay')
            ->field('pay.*')
            ->field('case pay.status 
                when 0 then "未缴费" 
                when 1 then "已缴费" 
                when 2 then "已上传发票" 
                when 3 then "凭证完整"
                when 4 then "已审核"
                end as status')
            ->field('epi.invoice_id')
            ->field('em.em_numb')
            ->field('r.region_name')
            ->join(['em_account'=>'ea'],'ea.account_id=pay.account_id')
            ->leftJoin(['em_payment_invoice'=>'epi'],'epi.payment_id = pay.payment_id')

            ->join(['em'],'em.id=ea.em_id')
            ->join(['station_info'=>'station'],'station.station_id=em.station_id')
            ->join(['region'=>'r'],'station.area_id = r.id')
            ->where($map)
            ->order('pay.id desc')
            ->page($Nowpage, $limits)
            ->select()
            ->toarray();
        foreach ($data as $k=>$item){
            $data[$k]['amount'] = round($data[$k]['amount'],3);
        }
        return $data;
    }
    public function getPaymentCount($map){

        //先找到账单
        $data = self::alias('pay')
            ->field('pay.*')
            ->field('em.em_numb')
            ->field('r.region_name')
            ->join(['em_account'=>'ea'],'ea.account_id=pay.account_id')
            ->leftJoin(['em_payment_invoice'=>'epi'],'epi.payment_id = pay.payment_id')
            ->join(['em'],'em.id=ea.em_id')
            ->join(['station_info'=>'station'],'station.station_id=em.station_id')
            ->join(['region'=>'r'],'station.area_id = r.id')
            ->where($map)
            ->count();
        return $data;
    }
    //通过缴费单id返回缴费单关联账单信息
    public function getinvsInfo($payment_id){
      //1.获取所关联账单的账单id,通过账单id查询账单信息
         $invIdArr = EmPaymentInvoice::field('invoice_id')->where('payment_id','=',$payment_id)->select()->toArray();

         //降维
        $invArr = [];
        foreach ($invIdArr as $inv){
            $invArr[] = $inv['invoice_id'];
        }
        $invModel = new EmInvoice();
        $invs = $invModel->alias('inv')
                        ->field('inv.*')
                        ->field('station.station_name')
                        ->field('em.em_numb')
                        ->leftJoin(['em_invoice_useage'=>'eiu'],'eiu.invoice_id=inv.invoice_id')
                        ->leftJoin(['em_useage'=>'eu'],'eu.useage_id = eiu.useage_id')
                        ->leftJoin(['em'],'em.id=eu.em_id')
                        ->leftJoin(['station_info'=>'station'],'station.station_id=em.station_id')
                        ->where(['inv.invoice_id'=>$invArr])
                        ->select();
        return $invs;
    }

    //获取所有缴费类型
    public static function getAllType(){
        $data = EmPaymentType::field('id,title')->select()->toArray();
        return $data;
    }

    //解析一个缴费类型
    public static function getTypeByTypeId($id){
        $types = self::getAllType();
        foreach ($types as $type){
            if($type['id'] == $id){
                return $type['title'];
            }
        }
    }
}