<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-9
 * Time: 21:48
 */

namespace app\admin\validate;


use think\Validate;

class ResetValidate extends Validate
{
    protected $rule = [
        'old_password' => 'require|max:32',
        'password' => 'require|max:32|confirm',
        'password_confirm' => 'require'
    ];

    protected $message = [
        'old_password.require' => '原始密码必填',
        'old_password.max' => '原始密码不能超过32个字符',
        'password.require' => '新密码必填',
        'password.max' => '新密码不能超过32个字符',
        'password.confirm' => '新密码不一致',
        'password_confirm.require' => '请填写确认密码',
    ];
}