<?php
namespace app\admin\model;

use think\Request;
use think\db\Where;
use think\Db;
use app\admin\model\StaffModel;
class BaseStationModel extends BaseModel
{
    protected $table = 'station_info';

    public function list($map=[],$pageConf=['list_rows'=>10]){
 
  	   $data= $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,proj_number,department_id,cate_name,name,operator_name')
        ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
        ->leftjoin('vendor_info','vendor_info.vendor_id=station_info.station_id')
        ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
        ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
        ->leftjoin('department','department.id=station_info.department_id')->where(new where($map))->order('station_id desc')->paginate($pageConf,false,
               ['query'=>request()->param()]);
        return $data;
    }

    //业务线
   public function  getbussById($name){
    $business[]=['business_name','=',$name];
    $business= Db::name('business_line')->field("business_id")->where($business)->find();
     return  $business['business_id'];
    }
    // 基站状态
     public function  getstatusById($name){
    $status[]=['cate_name','=',$name];
    $status= Db::name('station_statuscate')->field("cate_id")->where($status)->find();
    return  $status['cate_id'];
    }
    // 区域
     public function  getregionById($name){
        $region[]=['region_name','=',$name];
        $region=  Db::name('region')->field("id")->where($region)->find();
        return  $region['id'];
    }
    // 运营商
     public function  getoriginalById($name){
    $operator[]=['operator_name','=',$name];
    $operator=  Db::name('operator')->field("operator_id")->where($operator)->find();
    return  $operator['operator_id'];
    }
    // 部门
     public function  getdepartById($name){
    $department[]=['name','=',$name];
    $department= Db::name('department')->field("id")->where($department)->find();
    return  $department['id'];
    }
    // 需求来源
    public function  getsourceId($name){
    $where[]=['sources_name','=',$name];
    $source= Db::name('demand_source')->field("sources_id")->where($where)->find();
    return  $source['sources_id'];
    }
    // 上游客户
    public function  getcustomersId($name){
    $where[]=['customers_name','=',$name];
    $customers= Db::name('upstream_customers')->field("customers_id")->where($where)->find();
    return  $customers['customers_id'];
    }
    // 频段
    public function  getfrequencybandId($name){
    $where[]=['frequencyband_name','=',$name];
    $frequency= Db::name('frequencyband')->field("frequencyband_id")->where($where)->find();
    return  $frequency['frequencyband_id'];
    }
     // 项目编号
    public function  getproId($name){
    $where[]=['frequencyband_name','=',$name];
    $frequency= Db::name('frequencyband')->field("frequencyband_id")->where($where)->find();
    return  $frequency['frequencyband_id'];
    }

      public  function selectBaseStationList($map,$Nowpage,$limits){
      
        $data = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,proj_number,department_id,cate_name,name,operator_name,longitude,latitude,business_name,region_name')
        ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
        ->leftjoin('vendor_info','vendor_info.vendor_id=station_info.station_id')
        ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
        ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
        ->leftjoin('department','department.id=station_info.department_id')
        ->leftjoin('business_line','business_line.business_id=station_info.business_line_id')
        ->leftjoin('region','region.id=station_info.area_id')
        ->where($map)->page($Nowpage, $limits)->order('station_id desc')->select()->toarray();
       return $data;
    }
     public  function selectBaseStationCount($map){
      
        $data = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,proj_number,department_id,cate_name,name,operator_name,longitude,latitude,business_name,region_name')
        ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
        ->leftjoin('vendor_info','vendor_info.vendor_id=station_info.station_id')
        ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
        ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
        ->leftjoin('department','department.id=station_info.department_id')
        ->leftjoin('business_line','business_line.business_id=station_info.business_line_id')
        ->leftjoin('region','region.id=station_info.area_id')
        ->where($map)->count();
       return $data;
    }

       public  function getAllBaseStation($map){
         $data = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,location,proj_number,sp_req_code,longitude,latitude,rru_zimuth,business_line_id,antenna_number,rod_number,box_number,rru_number,frequencyband_id,optical_cable,v.construction_number,v.three_level_manager,v.salesman,CASE v.type WHEN 1 THEN "自建" WHEN 2 THEN "外围" WHEN 3 THEN "挂靠" ELSE "" END type,cate_name,name,operator_name,region_name,business_name,customers_name,sources_name')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->leftjoin(['vendor_info'=>'v'],'v.vendor_id=station_info.station_id')
            ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
            ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
            ->leftjoin('department','department.id=station_info.department_id')
            ->leftjoin('business_line','business_line.business_id=station_info.business_line_id')
            ->leftjoin('region','region.id=station_info.area_id')
             ->leftjoin('upstream_customers','upstream_customers.customers_id=station_info.customers_id')
            ->leftjoin('demand_source','demand_source.sources_id=station_info.sources_id')
            ->where($map)->select()->toarray();
         return $data;
        }
}