<?php 
namespace app\station\model;
use think\Model;
use think\model\concern\SoftDelete;
class OperatorModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键id
    protected $pk = 'operator_id';
    //数据表
    protected $table = 'operator';

    public  function selectOperatorList(){
     $data = $this->field("operator_id,operator_name,operator_state")->where('operator_state','=',1)->select()->toarray();
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }
    public function insertOperator($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }

    public function updOperator($parem){
        try {
           $data=$this->allowField(true)->where(['operator_id' => $parem['operator_id']])->find();
           if($data){
                 $result=$this->allowField(true)->save($parem,['operator_id' => $parem['operator_id']]);
                if($result){
                     return ['code' => 200, 'data' => '', 'message' => '修改成功'];
                }else{
                     return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
           }else{
               return ['code' => 10001, 'data' => '', 'message' => '没有id'];
           }
           
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
      public  function updselectOperator($parem){
         $data = $this->field("operator_id,operator_name,operator_state")->where($parem)->find();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到id相关信息'];
         }
        }


    public function delOperator($parem){
         try {
            $data=$this->allowField(true)->where($parem)->find();
            if($data){
                $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            }else{
               return ['code' => 10001, 'data' => '', 'message' => $this->getError()];
            }
          
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}