<?php
namespace app\station\controller\v1;
use app\station\model\FrequencybandModel;
use think\Controller;
/**
 * 频段API接口控制器
 * 负责频段的增删改查
 * Class Frequencyband
 * @package app\station\controller
 */
class Frequencyband extends Controller
{
    /**
 * 基站频段数据列表
 */
    public function frequencyband_list()
    {
    	  $model=new FrequencybandModel;
    	  $data=$model->selectFrequencybandList();
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','Query error please try again');
          }
    	  
    }
/**
 * 添加基站频段
 */
      public function frequencyband_add()
    {
    	$parem=$this->request->post();
    	if($parem){
    	 $model=new FrequencybandModel;
    	 $result=$model->insertFrequencyband($parem);
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 修改基站频段
 */
     public function frequencyband_edit()
    {
    	 $parem=$this->request->post();
    	if($parem){
         if(empty($parem['frequencyband_id'])){
            return jsonSucc('200001','参数不合法，无法修改');
         }
    	 $model=new FrequencybandModel;
    	 $result=$model->updFrequencyband($parem);
    	 if($result['code']==10001){
    	 	return jsonSucc('200001','id不存在');
    	 }
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 获取修改基站频段数据
 */
    public function geteditfrequencyband()
    {
    	$parem=$this->request->post();
    	 $model=new FrequencybandModel;
    	 $result=$model->updselectFrequencyband($parem);
    	  if($result['code']==10001){
    	  	return jsonSucc('200001','暂无找到id');
    	  }else{
    	  	 return jsonSucc('','suceess',$result['data']);
    	  }
    	 
    }
/**
 * 删除频段数据（软删除）
 */
     public function frequencyband_del()
    { 
      $parem=$this->request->post();
    	if($parem){
    	 $model=new FrequencybandModel;
    	 $result=$model->delFrequencyband($parem);
    	 switch ($result['code']) {
    	 	case '10001':
    	 		 return jsonSucc('200001','暂无找到id');
    	 		break;
    	 	
    	 	case '200':
    	 		 return jsonSucc('200','suceess');
    	 		break;

    	 	default:
    	 		return jsonSucc('1000001','error');
    	 		break;
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
}