<?php
namespace app\em\model;
use app\admin\model\DepartmentModel;
use app\admin\model\RoleModel;
use app\admin\model\StaffModel;
use app\admin\model\StaffRoleModel;
use think\Session;

class Staff extends Base
{
    protected $table = 'staff';

    public function getStaffs($is_admin=false,$staff_id='',$filter=false){
        if($is_admin){
            $staffs = StaffModel::field('id,name')->select()->toArray();
        } else {
            if($staff_id == ''){
                $user  =  \think\facade\Session::get('user');
                $staff = StaffModel::where('id','=',$user['user_id'])->find();
            } else {
                $staff = StaffModel::where('id','=',$staff_id)->find();
            }
            $dIds = (new DepartmentModel)->getNodeIds($staff['d_id']);

            //过滤角色权限

            //if($filter == 'useage' && $staff->d_id == 19){
            if($filter == 'useage'){
                $role = RoleModel::get(['title'=>'抄表员']);
                if($role){
                    $fStaffIds = StaffRoleModel::where(['role_id'=>$role->id])->column('staff_id');
                    $staffs = StaffModel::field('id,name')
                                        ->where('d_id','in',$dIds)
                                        ->where('id','in',$fStaffIds)
                                        ->select()->toArray();
                } else {
                    $staffs = [];
                }
            } else {
                $staffs = StaffModel::field('id,name')
                    ->where('d_id','in',$dIds)
                    ->select()->toArray();
            }
        }
        return $staffs;
    }
}