<?php


namespace app\em\model;


class EmPaymentReceipt extends Base
{
    protected $table = 'em_payment_receipt';

    //获取带有类型文字描述的列表集合
    public function getPaymentReceiptByPaymentId($payment_id){
        $data = self::alias('r')
                    ->field('*')
                    ->field('ert.title as receipt_type_title')
                    ->field('receipt.src as file_src')
                    ->leftJoin(['em_receipt_type'=>'ert'],'ert.id = r.type')
                    ->leftJoin(['receipt'],'receipt.id = r.file_id')
                    ->where('payment_id','=',$payment_id)
                    ->select();
        return $data;
    }

    //携带附件
    public function file(){
        return $this->belongsTo('Receipt','file_id','id');
    }

    //携带类型名称
    public function types(){
        return $this->belongsTo('EmReceiptType','type','id');
    }
}