<?php
namespace app\api\validate;

use app\api\exception\ParamsException;
use think\facade\Request;
use think\Validate;

class BaseValidate extends Validate
{
    public function verify($data = []){

        if(empty($data))
            $params = Request::param();
        else
            $params = $data;

        if(!$this->batch()->check($params)){
            $ex = new ParamsException([
                'msg' => is_array($this->error)
                    ? implode(';', $this->error)
                    : $this->error
            ]);
            throw $ex;
        }
        return true;
    }


    protected function idMustInt($value,$rule='',$data=[],$field=''){
        if (is_numeric($value) && is_int($value + 0) && ($value + 0) > 0) {
            return true;
        }
        return $field . '必须是正整数';
    }
}