<?php
Route::get('/', 'admin/index/index');

Route::get('admin', 'admin/admin/index');
Route::get('admin_add', 'admin/admin/create');
Route::get('admin_edit/[:id]', 'admin/admin/edit');

Route::post('admin_add', 'admin/admin/store');
Route::post('admin_update', 'admin/admin/update');
Route::post('admin_del', 'admin/admin/delete');

Route::get('login','admin/login/index');
Route::get('login_out','admin/login/loginOut');
Route::post('login','admin/login/login');

Route::get('role','admin/role/index');
Route::get('role_add','admin/role/create');
Route::Post('role_add','admin/role/store');
Route::get('role_edit/:id','admin/role/edit');
Route::post('role_update','admin/role/update');
Route::post('role_del','admin/role/delete');
Route::get('verify','admin/login/verify');


Route::get('permission', 'admin/permission/index');
Route::get('permission_add','admin/permission/create');
Route::post('permission_add','admin/permission/store');
Route::get('permission_edit/:id','admin/permission/edit');
Route::post('permission_update','admin/permission/update');
Route::post('permission_del','admin/permission/delete');

Route::get('nav','admin/nav/index');

Route::get('staff','admin/staff/index');
Route::get('staff_add','admin/staff/create');
Route::post('staff_add','admin/staff/store');
Route::get('staff_edit/:id','admin/staff/edit');
Route::post('staff_update','admin/staff/update');
Route::post('staff_del','admin/staff/delete');
Route::post('staff_resetpass','admin/staff/resetPass');


Route::get('staff_role','admin/staff/role');
Route::post('staff_role_update','admin/staff/role_update');
Route::get('staff_role_edit/:id','admin/staff/role_edit');
Route::post('staff_role_del','admin/staff/role_del');

//部门

Route::post('depat_role_update','admin/staff/depat_role_update');
Route::get('staff_role_department/:id','admin/staff/staff_role_department');

Route::get('department','admin/department/index');
Route::get('department_add','admin/department/create');
Route::get('department_edit/:id','admin/department/edit');
Route::post('department_add','admin/department/store');
Route::post('department_del','admin/department/delete');

Route::get('element_permission','admin/ElementPermission/index');

Route::get('reset','admin/reset/edit');
Route::post('reset','admin/reset/update');


/*电表管理*/
//Route::get('em/[:pages]','admin/em/index');
Route::get('em_search_stations','admin/em/searchStations');
//Route::get('em_search_stations','em/em/create');

Route::post('em_search_stations','admin/em/getStations');
Route::any('em_search/[:pages]','admin/em/search');

//Route::get('em_add/:sid','admin/em/create');
//Route::post('em_add','admin/em/store');

//Route::get('em_edit/:id','admin/em/edit');
Route::post('em_update','admin/em/update');
Route::post('em_add_protocol','admin/em/storeProtocol');

Route::get('em_detail/:id','admin/em/show');


/*抄表单管理*/
//Route::get('copy','admin/copy/index');
Route::get('copy/:id','admin/copy/create');
Route::post('copy_add','admin/copy/store');
Route::post('copy_del','admin/copy/del');
Route::post('cp_import','admin/copy/import');
Route::post('cp_import_only','admin/copy/importOnly');

Route::get('cp_export','admin/copy/export');

Route::get('copy_show/:id','admin/copy/detail');

Route::rule('copy_search','admin/copy/search','GET|POST');
//Route::get('copy_search/:page','admin/copy/search');
//Route::post('copy_search','admin/copy/search');
Route::post('up_photo','admin/copy/upPhoto');

//添加账单信息 step2
Route::get('statement_add/:id','admin/statement/create');
Route::post('statement_add','admin/statement/store');

Route::post('up_cp_photo','admin/statement/upCpPhoto');
Route::post('up_invoice','admin/payment/upInvoice');

//添加账单信息 step3
Route::get('payment_add/:cp_id','admin/payment/create');
Route::post('payment_add','admin/payment/store');

//添加账单信息 step4
Route::get('settle_add/:cp_id','admin/settle/create');
Route::post('settle_add','admin/settle/store');

Route::post('order_check','admin/order/check');

//查询基站信息
Route::post('select_by_tag','admin/station/selectStationByTag');

//文件上传
Route::post('upProtocol','admin/em/upProtocol');
Route::post('upAnnex','admin/em/upAnnex');

//系统设置
Route::get('sys','admin/system/index');

//导入导出
Route::get('em_export','admin/em/export');
Route::any('em_import','admin/em/import');

Route::post('apply_confirm','admin/order/applyConfirm');
Route::post('confirm','admin/order/confirm');


//v2.0
Route::get('em_add/:sid','em/em/create');
Route::post('em_add','em/em/store');
Route::get('em','em/em/index');
Route::get('em_edit/:id','em/em/update');
Route::post('em_check','em/em/check');


//抄表单
Route::get('useage','em/useage/index');
Route::post('useage/check','em/useage/check');
Route::get('useage/:useage_id','em/useage/detail');
Route::get('useage_add/:id','em/useage/create');
Route::post('useage_add','em/useage/store');
Route::post('useage_del','em/useage/del');
Route::post('upFile','em/UploadFile/upFile');


//账单
Route::get('invoice','em/invoice/index');
Route::get('invoice/:id','em/invoice/detail');
Route::get('invoice/createAll','em/invoice/createAll');
Route::post('invoice/update/payment','em/invoice/updatePayment');
Route::get('invoice/merge/list/[:ids]','em/invoice/mergeList');

//缴费
Route::get('payment','em/payment/index');
Route::get('payment/payDetail/:invoice_id','em/payment/payDetail');
Route::get('payment/pay/:em_id','em/payment/create');
Route::get('payment/:payment_id','em/payment/detail');
Route::post('payment/createAll','em/payment/createAll');
Route::post('payment/update','em/payment/update');
Route::post('payment/save','em/payment/store');
Route::post('payment/confirm','em/payment/confirm');

//结算
Route::get('settle','em/settle/index');
Route::get('settle/settleDetail/:invoice_id','em/settle/settleDetail');
Route::post('settle/createAll','em/settle/createAll');
Route::get('settle/:settle_id','em/settle/detail');
Route::post('settle/save','em/settle/store');
Route::post('settle/confirm','em/settle/confirm');

//缴费发票
Route::get('receipt/create/:payment_id','em/receipt/create');
Route::get('receipt/receipts/:payment_id','em/receipt/receipts');
Route::post('receipt/save','em/receipt/store');

//结算发票
Route::get('receiptSettle/create/:settle_id','em/ReceiptSettle/create');
Route::get('receiptSettle/receipts/:settle_id','em/ReceiptSettle/receipts');
Route::post('receiptSettle/save','em/ReceiptSettle/store');

//缴费支票
Route::get('cert/create/:payment_id','em/cert/create');
Route::get('cert/certs/:payment_id','em/cert/certs');
Route::post('cert/save','em/cert/store');

//结算支票
Route::get('certSettle/create/:settle_id','em/CertSettle/create');
Route::get('certSettle/certs/:settle_id','em/CertSettle/certs');
Route::post('certSettle/save','em/CertSettle/store');


Route::any('region_data','em/region/region_list');