<?php 
namespace app\station\model;
use think\Model;
use think\model\concern\SoftDelete;
class BaseStationStatusAttributesModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键attribute_id
    protected $pk = 'attribute_id';
    //数据表
    protected $table = 'basestation_status_attributes';

    public  function selectBaseStationStatusAttributesList(){
     $data = $this->field("attribute_id,title,path,state,type,cid")->where('state','=',1)->select()->toarray();
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }
    public function insertBaseStationStatusAttributes($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }

    public function updBaseStationStatusAttributes($parem){
        try {
           $data=$this->allowField(true)->where(['attribute_id' => $parem['attribute_id']])->find();
           
           if($data){
                if($parem['path']){
                   unlink($_SERVER['DOCUMENT_ROOT'].$data['path']);  
                }
                 $result=$this->allowField(true)->save($parem,['attribute_id' => $parem['attribute_id']]);
                if($result){
                     return ['code' => 200, 'data' => '', 'message' => '修改成功'];
                }else{
                     return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
           }else{
               return ['code' => 10001, 'data' => '', 'message' => '没有attribute_id'];
           }
           
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
     /**
     * [getOneBaseStationStatusAttributes 根据基站状态属性id获取一条信息]
     * 
     */
      public  function getOneBaseStationStatusAttributes($parem){
         $data = $this->field("attribute_id,title,path,state,type,cid")->where($parem)->find();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到attribute_id相关信息'];
         }
        }


    public function delBaseStationStatusAttributes($parem){
         try {
            $data=$this->allowField(true)->where($parem)->find();
            if($data){
                $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            }else{
               return ['code' => 10001, 'data' => '', 'message' => $this->getError()];
            }
          
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}