<?php
namespace app\station\controller\v1;
use app\station\model\UpstreamCustomersModel;
use think\Controller;
/**
 * 上游客户API接口控制器
 * 负责需上游客户的增删改查
 * Class UpstreamCustomers
 * @package app\station\controller
 */
class UpstreamCustomers extends Controller
{
    /**
 * 基站上游客户数据列表
 */
    public function upstreamCustomers_list()
    {
    	  $model=new UpstreamCustomersModel;
    	  $data=$model->selectUpstreamCustomersList();
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','Query error please try again');
          }
    	  
    }
/**
 * 添加基站上游客户
 */
      public function upstreamCustomers_add()
    {
    	$parem=$this->request->post();
    	if($parem){
    	 $model=new UpstreamCustomersModel;
    	 $result=$model->insertUpstreamCustomers($parem);
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 修改基站上游客户
 */
     public function upstreamCustomers_edit()
    {
    	 $parem=$this->request->post();
    	if($parem){
    	 $model=new UpstreamCustomersModel;
    	 $result=$model->updUpstreamCustomers($parem);
    	 if($result['code']==10001){
    	 	return jsonSucc('200001','id不存在');
    	 }
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 获取修改基站上游客户数据
 */
    public function getCustomers()
    {
    	$parem=$this->request->post();
    	 $model=new UpstreamCustomersModel;
    	 $result=$model->getUpstreamCustomers($parem);
    	  if($result['code']==10001){
    	  	return jsonSucc('200001','暂无找到id');
    	  }else{
    	  	 return jsonSucc('','suceess',$result['data']);
    	  }
    	 
    }
/**
 * 删除上游客户数据（软删除）
 */
     public function upstreamCustomers_del()
    { 
      $parem=$this->request->post();
    	if($parem){
    	 $model=new UpstreamCustomersModel;
    	 $result=$model->delUpstreamCustomers($parem);
    	 switch ($result['code']) {
    	 	case '10001':
    	 		 return jsonSucc('200001','暂无找到id');
    	 		break;
    	 	
    	 	case '200':
    	 		 return jsonSucc('200','suceess');
    	 		break;

    	 	default:
    	 		return jsonSucc('1000001','error');
    	 		break;
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
}