<?php
namespace app\em\validate;
use think\Validate;

class AddCertValidate extends Validate
{
    protected $rule = [
        'type' => 'require',
        'numb' => 'require',
        'pay_date' => 'require|date',
        'file_id' => 'require',
        'amount' => 'require|checkData',
        'settle_date'=>'require|date',
    ];

    protected $message = [
        'numb.require' => '请填写缴费凭证号',
        'pay_date.require' => '请选择缴费日期',
        'amount.require' => '请填写缴费金额',
        'file_id.require' => '选上传缴费凭证',
        'amount.number' => '缴费金额只能是数字',
        'settle_date.require'=>'请选择结算日期'
    ];

    protected $scene = [
        'type1' => 'type,numb,pay_date,file_id,amount',
        'type2' => 'type,pay_date,file_id,amount',
        'type3' => 'type,numb,settle_date,file_id,amount',
        'type4' => 'type,settle_date,file_id,amount',
    ];

    //校验上传表单数值合法
    protected function checkData($value,$rule,$data=[]){
        if($data['balance'] == 0){
            return true;
        }
        if($value > $data['balance']){
            return '缴费金额不能大于应缴金额';
        } else {
            return true;
        }
    }
}