<?php

/**
 * 员工信息接口
 */
namespace app\api\controller\v1\supplier;
use think\Db;
use think\facade\Session;

class Staff
{
    /**
     * 接口一：需要获取登陆人信息的接口 返回值： id name 工号 部门id 角色id（多个的话，逗号分隔）
     */
    public function getCurrentStaff(){
        $user = Session::get('user');

        //如果不是超级管理员
        if(!$user['is_admin']) {
            $staff = Db::table('staff')
                ->field('staff.id,name,d_id,iden_id,email,si.title as iden_name')
                ->leftJoin(['staff_identity'=>'si'],'si.id = staff.iden_id')
                ->where('staff.id','=',$user['user_id'])
                ->find();
            $staff_roles = Db::table('staff_role')->where('staff_id', '=', $staff['id'])->column('role_id');
            $staff['roles'] = implode(',',$staff_roles);

            $data = [
                'code' => 200,
                'message' => 'ok',
                'data' => $staff
            ];
        } else {
            $data = [
                'code' => 200,
                'message' => 'admin',
                'data' => []
            ];
        }
        return json($data);
    }

    //获取员工列表信息
    public function getStaffs(){
        $staffs = Db::table('staff')
            ->field('staff.id,name,d_id,iden_id,email,si.title as iden_name')
            ->leftJoin(['staff_identity'=>'si'],'si.id = staff.iden_id')
            ->select();

        foreach ($staffs as $k => $v){
            //获取角色信息
            $staff_roles = Db::table('staff_role')->where('staff_id', '=', $v['id'])->column('role_id');
            if(is_array($staff_roles) && count($staff_roles) > 0){
                $roles = implode(',',$staff_roles);
            } else {
                $roles = $staff_roles ?: '';
            }
            $staffs[$k]['roles'] = $roles;

        }
        $data = [
            'code' => 200,
            'message' => 'ok',
            'data' => $staffs
        ];
        return json($data);
    }

    public function getIdentities(){
        $data = Db::table('staff_identity')->column('id,title,level');
        return json([
            'code' => 200,
            'message' => 'ok',
            'data' => $data
        ]);
    }
}