<?php
namespace app\admin\model;

class StaffRoleModel extends BaseModel
{
    protected $table = 'staff_role';

    public static function getStaffRolesById($id){
        $roles = self::field('role_id')->where(['staff_id'=>$id])->select()->toArray();

        $permissionIds = '';
        foreach ($roles as $role){
            $permission = RolePermissionModel::where(['r_id'=>$role['role_id']])->field('p_ids')->find();

            if($permission != null){
                $permission = $permission->toArray();
                $permissionIds .= $permission['p_ids'].',';
            }
        }
        $permissions = array_filter(array_unique(explode(',',$permissionIds)));
        asort($permissions);

        $permissions = implode(',',$permissions);
        return $permissions;
    }
}