<?php
use think\db;
use think\facade\Session;
function check_data(){
    $user = session('user');
    //查找数据权限规则表
    $map=[];
    $permission=db::name('permission_data')->field('permission_ids')->where(['s_id'=>$user['user_id']])->find();
    $arr= json_decode($permission['permission_ids'],true);
    if($arr['department_id']){
        $department_ids=strpos($arr['department_id'],',');
        if($department_ids===false){
            $map[]=['department_id','=', $arr['department_id']];
        }else{
            $map[]=['department_id','in',$arr['department_id']];
        }
    }
    if($arr['region_id']){
        $area_ids=strpos($arr['region_id'],',');
        if($area_ids===false){
            $map[]=['area_id','=', $arr['region_id']];
        }else{
            $map[]=['area_id','in',$arr['region_id']];
        }
    }
    if($arr['business_id']){
        $business_ids=strpos($arr['business_id'],',');
        if($business_ids===false){
            $map[]=['business_line_id','=', $arr['business_id']];
         }else{
            $map[]=['business_line_id','in',$arr['business_id']];
         }
    }
     //如果数据规则表不存在数据信息 ，默认返回此用户的部门id
    if(!$map){
     $staff = db::name('staff')->field('d_id')->where(['id'=>$user['user_id']])->find();
     if($staff && $staff['d_id']!==0){
        $map[]=['department_id','=',$staff['d_id']];
     }
    }
    return $map;
}
function loginlog($name,$id,$desc,$status){
    $login['staff_id']=$id;
    $login['name']=$name;
    $login['description']=$desc;
    $login['ip']=\think\facade\Request::ip();
    $login['status']=$status;
    $login['create_time']=time();
   db::name('loginlog')->insert($login);

}
function activity_log($name,$desc,$type){

    $login['name']=$name;
    $login['description']=$desc;
    $login['type']=$type;
    $login['create_time']=time();
   db::name('activity_log')->insert($login);

}
function curlGet($url=''){
        $curl = curl_init(); // 启动一个CURL会话
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // 跳过证书检查
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);  // 从证书中检查SSL加密算法是否存在
        $tmpInfo = curl_exec($curl);     //返回api的json对象
        //关闭URL请求
        curl_close($curl);
        return $tmpInfo;    //返回json对象
}

function httpPOST($url , $post_data = array()){
        $headers = array('Content-Type: application/x-www-form-urlencoded');
        $curl = curl_init(); // 启动一个CURL会话
        curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址
        curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览器
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); // 使用自动跳转
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1); // 自动设置Referer
        curl_setopt($curl, CURLOPT_POST, 1); // 发送一个常规的Post请求
        curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query($post_data)); // Post提交的数据包
        curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循环
        curl_setopt($curl, CURLOPT_HEADER, 0); // 显示返回的Header区域内容
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); // 获取的信息以文件流的形式返回
        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
        $result = curl_exec($curl); // 执行操作
        if (curl_errno($curl)) {
        echo 'Errno'.curl_error($curl);//捕抓异常
        }
        curl_close($curl); // 关闭CURL会话
        return $result;
}
function decrypt ($pass) {
    return md5($pass.config('admin.passwd_salt'));
}

//生成10位的随机密码
function createPass(){
    return substr(md5(config('admin.passwd_salt').time()),0,10);
}

//生成10位的随机密码

//将密码返回给控制器
//控制器通过MD加密之后存储到数据库


/**
 * 基站状态递归实现无限极分类
 * @param $array 分类数据
 * @param $pid 父ID
 * @param $level 分类级别
 * @return $list 分好类的数组 直接遍历即可 $level可以用来遍历缩进
 */
function getTreeStatus($array, $pid =0, $level = 0){
    //声明静态数组,避免递归调用时,多次声明导致数组覆盖
    static $list = [];
    foreach ($array as $key => $value){
        //第一次遍历,找到父节点为根节点的节点 也就是pid=0的节点
        if ($value['pid'] == $pid){
            //父节点为根节点的节点,级别为0，也就是第一级
            $value['level'] = $level;
            //把数组放到list中
            $list[] = $value;
            //把这个节点从数组中移除,减少后续递归消耗
            unset($array[$key]);
            //开始递归,查找父ID为该节点ID的节点,级别则为原级别+1
            getTreeStatus($array, $value['cate_id'], $level+1);
        }
    }
    return $list;
}
/**
 * 递归实现无限极分类
 * @param $array 分类数据
 * @param $pid 父ID
 * @param $level 分类级别
 * @return $list 分好类的数组 直接遍历即可 $level可以用来遍历缩进
 */
function getTree($array, $pid =0, $level = 0){
    //声明静态数组,避免递归调用时,多次声明导致数组覆盖
    static $list = [];
    foreach ($array as $key => $value){
        //第一次遍历,找到父节点为根节点的节点 也就是pid=0的节点
        if ($value['pid'] == $pid){
            //父节点为根节点的节点,级别为0，也就是第一级
            $value['level'] = $level;
            //把数组放到list中
            $list[] = $value;
            //把这个节点从数组中移除,减少后续递归消耗
            unset($array[$key]);
            //开始递归,查找父ID为该节点ID的节点,级别则为原级别+1
            getTree($array, $value['id'], $level+1);
        }
    }
    return $list;
}

function getNodesTree($array,$pid=0){
    $list = [];
    foreach ($array as $k => $v) {
        if ($v['pid'] == $pid) {
            $v['children'] = getNodesTree($array, $v['id']);
            $list[] = $v;
        }
    }
    return $list;
}

function getNodeIds($data,$pid=0){
    static $nodes = [];

    if(empty($nodes)){
        $nodes[] = $pid;
    }
    foreach ($data as $k=>$v){
        if ($v['pid'] == $pid){
             $nodes [] = $v['id'];
             getNodesTree($data,$v['id']);
             unset($data[$k]);
        }
    }
    return $nodes;
}


function jsonSuc($message,$data=''){
    if(!empty($data)){
        return json([
            'status' => 1,
            'message' => $message,
            'data' => $data
        ]);
    } else {
        return json([
            'status' => 1,
            'message' => $message
        ]);
    }
}

function jsonErr($err){
    return json([
        'status' => 0,
        'message' => $err
    ]);
}

function dd($mix)
{
    echo "<pre/>";
    var_dump($mix);
    die;
}
