<?php 
namespace app\station\model;
use think\Model;
use think\model\concern\SoftDelete;
class FrequencybandModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键id
    protected $pk = 'frequencyband_id';
    //数据表
    protected $table = 'frequencyband';

    public  function selectFrequencybandList(){
     $data = $this->field("frequencyband_id,frequencyband_name,frequencyband_state")->select()->toarray();
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }
    public function insertFrequencyband($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }

    public function updFrequencyband($parem){
        try {
           $data=$this->allowField(true)->where(['frequencyband_id' => $parem['frequencyband_id']])->find();
           if($data){
                 $result=$this->allowField(true)->save($parem,['frequencyband_id' => $parem['frequencyband_id']]);
                if($result){
                     return ['code' => 200, 'data' => '', 'message' => '修改成功'];
                }else{
                     return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
           }else{
               return ['code' => 10001, 'data' => '', 'message' => '没有id'];
           }
           
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
      public  function updselectFrequencyband($parem){
         $data = $this->field("frequencyband_id,frequencyband_name,frequencyband_state")->where($parem)->find();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到id相关信息'];
         }
        }


    public function delFrequencyband($parem){
         try {
            $data=$this->allowField(true)->where($parem)->find();
            if($data){
                $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            }else{
               return ['code' => 10001, 'data' => '', 'message' => $this->getError()];
            }
          
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}