<?php 
namespace app\station\model;
use think\Model;
use think\model\concern\SoftDelete;
class DepartmentModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键id
    protected $pk = 'id';
    //数据表
    protected $table = 'department';

    public  function selectDepartmentList(){
     $data = $this->field("id,name,pid,sort")->select()->toarray();
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }
    public function insertDepartment($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }

    public function updDepartment($parem){
        try {
            $result=$this->allowField(true)->save($parem,['id' => $parem['id']]);
            if($result){
                 return ['code' => 200, 'data' => '', 'message' => '修改成功'];
            }else{
                 return ['code' => -1, 'data' => '', 'message' => $this->getError()];
            }
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
      public  function getOneDepartment($parem){
         $data = $this->field("id,name,pid,sort")->where($parem)->find();
          if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到 id 相关信息'];
         }
        }


    public function delDepartment($parem){
         try {
            $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}