<?php 
namespace app\station\model;
use think\Model;
use think\Db;
use think\model\concern\SoftDelete;

class BaseStationModel extends Model
{
    use SoftDelete;
    protected static $deleteTime = 'delete_time';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = true;
    //主键station_id
    protected $pk = 'station_id';
    //数据表
    protected $table = 'station_info';
    //基站列表
    public  function selectBaseStationList($map,$Nowpage,$limits,$desc){
      
        $data = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,proj_number,department_id,cate_name,name,operator_name,longitude,latitude')
        ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
        ->leftjoin('vendor_info','vendor_info.vendor_id=station_info.station_id')
        ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
        ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
        ->leftjoin('department','department.id=station_info.department_id')
        ->where($map)->page($Nowpage, $limits)->order('station_id'.' '.$desc)->select()->toarray();
     //total_count总记录数
        $total_count = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,proj_number,department_id,cate_name,name,operator_name')
        ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
        ->leftjoin('vendor_info','vendor_info.vendor_id=station_info.station_id')
        ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
        ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
        ->leftjoin('department','department.id=station_info.department_id')
        ->where($map)->order('station_id'.' '.$desc)->count();
        // 总共多少页total_page
 
    $total_page = intval(ceil($total_count / $limits));
    //当前页码current_page
    $current_page=$Nowpage;
            if($data){
                 return ['code' =>200,'message' => '查询成功' ,'data' => $data ,'total_count'=>$total_count,'total_page'=>$total_page,'current_page'=>$current_page];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
    }

    public function insertBaseStation($parem){
        try {
            $result=$this->allowField(true)->save($parem);
            if($result){
                if($parem['latitude']  && $parem['longitude']){
                $datainfo['stationid']=$this->station_id;
                $datainfo['latitude']=$parem['latitude'];
                $datainfo['longitude']=$parem['longitude'];
                $datainfo['create_time']=time();
                $datainfo['update_time']=time();
                 Db::name('station_info_detai')->insert($datainfo);
                }
                 $vendor['vendor_id']=$this->station_id;
                 $vendor['salesman']=$parem['salesman'];
                 Db::name('vendor_info')->insert($vendor);
                 return ['code' =>200,'message' => '添加成功'];
            }else{
                 return ['code' => -1,  'message' => $this->getError()];
            }
        } catch (Exception $e) {
               return ['code' => 0, 'message' => $e->getMessage()];
        }
     }
   
    public function updBaseStation($parem){
        try {
           $id=$parem['station_id'];
           $data=$this->allowField(true)->where(['station_id' => $parem['station_id']])->find();
           if($data){
            unset($parem['station_id']);
                 $result=Db::name('station_info_detai')->where(['stationid' => $id])->update($parem);
                 
                if($result){
                     return ['code' => 200, 'data' => '', 'message' => '修改成功'];
                }else{
                     return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
           }else{
               return ['code' => 10001, 'data' => '', 'message' => '没有station_id'];
           }
           
        } catch (Exception $e) {
             return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
        }
     }
     /**
     * [getOneBaseStation 根据基站id获取一条信息]
     * 
     */
      public  function getOneBaseStation($parem){

         $data = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,location,proj_number,sp_req_code,longitude,latitude,rru_zimuth,business_line_id,antenna_number,rod_number,box_number,rru_number,optical_cable,v.construction_number,v.three_level_manager,v.salesman,CASE v.type WHEN 1 THEN "自建" WHEN 2 THEN "外围" WHEN 3 THEN "挂靠" ELSE "" END type,cate_name,name,operator_name,region_name,business_name,customers_name,sources_name')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->leftjoin(['vendor_info'=>'v'],'v.vendor_id=station_info.station_id')
            ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
            ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
            ->leftjoin('department','department.id=station_info.department_id')
            ->leftjoin('business_line','business_line.business_id=station_info.business_line_id')
            ->leftjoin('region','region.id=station_info.area_id')
            ->leftjoin('upstream_customers','upstream_customers.customers_id=station_info.customers_id')
            ->leftjoin('demand_source','demand_source.sources_id=station_info.sources_id')
           ->leftjoin('frequencyband','frequencyband.frequencyband_id=station_info_detai.frequencyband_id')
            ->where(['station_id' => $parem['station_id']])->find();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到station_id相关信息'];
         }
        }
     
      public  function getAllBaseStation($parem){
         $data = $this->field('station_id,original_sp_id,base_station_state,area_id,station_name,station_sp_code,location,proj_number,sp_req_code,longitude,latitude,rru_zimuth,business_line_id,antenna_number,rod_number,box_number,rru_number,frequencyband_id,optical_cable,v.construction_number,v.three_level_manager,v.salesman,CASE v.type WHEN 1 THEN "自建" WHEN 2 THEN "外围" WHEN 3 THEN "挂靠" ELSE "" END type,cate_name,name,operator_name,region_name,business_name,customers_name,sources_name')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->leftjoin(['vendor_info'=>'v'],'v.vendor_id=station_info.station_id')
            ->leftjoin('station_statuscate','station_statuscate.cate_id=station_info.base_station_state')
            ->leftjoin('operator','operator.operator_id=station_info.original_sp_id')
            ->leftjoin('department','department.id=station_info.department_id')
            ->leftjoin('business_line','business_line.business_id=station_info.business_line_id')
            ->leftjoin('region','region.id=station_info.area_id')
             ->leftjoin('upstream_customers','upstream_customers.customers_id=station_info.customers_id')
            ->leftjoin('demand_source','demand_source.sources_id=station_info.sources_id')
            ->where($parem)->select()->toarray();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到station_id相关信息'];
         }
        }
   public  function getMapBaseStation($parem){
         $data = $this->field('station_id,station_name,proj_number,longitude,latitude')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->where(['station_id' => $parem['station_id']])->select()->toarray();
         if($data){
              return ['code' => 200, 'data' => $data, 'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到station_id相关信息'];
         }
        }
           public  function getAllMapList($parem){
            $counts= $this->field('station_id,station_name,proj_number,longitude,latitude')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->where($parem)->count();
            $parem[]=['longitude','neq',''];
            $parem[]=['latitude','neq',''];
             $data = $this->field('station_id,station_name,proj_number,longitude,latitude')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->where($parem)->limit(100)->select()->toarray();
            $datacount = $this->field('station_id,station_name,proj_number,longitude,latitude')
            ->leftjoin('station_info_detai','station_info_detai.stationid=station_info.station_id')
            ->where($parem)->count();
         if($data){
              return ['code' => 200, 'data' => $data, 'counts'=>$counts,'datacount'=>$datacount,'message' => '查询成功'];
         }else{
             return ['code' => 10001, 'data' => '', 'message' => '暂未找到station_id相关信息'];
         }
        }
    public function baseStation_del($parem){
         try {
            $data=$this->allowField(true)->where($parem)->find();
            if($data){
                $result=$this->destroy($parem);
                if($result){
                return ['code' => 200, 'data' => '', 'message' => '删除成功'];
                }else{
                return ['code' => -1, 'data' => '', 'message' => $this->getError()];
                }
            }else{
               return ['code' => 10001, 'data' => '', 'message' => $this->getError()];
            }
            } catch (Exception $e) {
                 return ['code' => 0, 'data' => '', 'message' => $e->getMessage()];
            }
        }
}
