<?php
namespace app\station\controller\v1;
use app\station\model\RegionModel;
use think\Controller;
use think\db;
/**
 * 区域API接口控制器
 * 负责区域的增删改查
 * Class Region
 * @package app\station\controller
 */
class Region extends Controller
{
    /**
 * 基站区域数据列表
 */
    public function region_list()
    {
         $map=[];
    	  $model=new RegionModel;
        $user_id = $this->request->get('user_id');
         if($user_id){
           $user = session('user');
          $permission=db::name('permission_data')->field('permission_ids')->where(['s_id'=>$user_id])->find();
              $arr= json_decode($permission['permission_ids'],true);
                if($arr['region_id']){
                    $area_ids=strpos($arr['region_id'],',');
                    if($area_ids===false){
                        $map[]=['id','=', $arr['region_id']];
                    }else{
                        $map[]=['id','in',$arr['region_id']];
                    }
                }
            }
    	  $data=$model->selectRegionList($map);
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','Query error please try again');
          }
    	  
    }
/**
 * 添加基站区域
 */
      public function region_add()
    {
    	$parem=$this->request->post();
    	if($parem){
    	 $model=new RegionModel;
    	 $result=$model->insertRegion($parem);
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 修改基站区域
 */
     public function region_edit()
    {
    	 $parem=$this->request->post();
    	if($parem){
         if(empty($parem['id'])){
            return jsonSucc('200001','参数不合法，无法修改');
         }
    	 $model=new RegionModel;
    	 $result=$model->updRegion($parem);
    	 if($result['code']==10001){
    	 	return jsonSucc('200001','id不存在');
    	 }
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 获取修改基站区域数据
 */
    public function geteditregion()
    {
    	$parem=$this->request->post();
    	 $model=new RegionModel;
    	 $result=$model->updselectRegion($parem);
    	  if($result['code']==10001){
    	  	return jsonSucc('200001','暂无找到id');
    	  }else{
    	  	 return jsonSucc('','suceess',$result['data']);
    	  }
    	 
    }
/**
 * 删除区域数据（软删除）
 */
     public function region_del()
    { 
      $parem=$this->request->post();
    	if($parem){
    	 $model=new RegionModel;
    	 $result=$model->delRegion($parem);
    	 switch ($result['code']) {
    	 	case '10001':
    	 		 return jsonSucc('200001','暂无找到id');
    	 		break;
    	 	
    	 	case '200':
    	 		 return jsonSucc('200','suceess');
    	 		break;

    	 	default:
    	 		return jsonSucc('1000001','error');
    	 		break;
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
}