<?php
namespace app\em\validate;
use think\Validate;

class UseageGeneralInfoValidate extends Validate
{
    protected $rule = [
        'em_id' => 'require',
        'last_numb' => 'require',
        'last_date' => 'require|date',
        'current_numb' => 'require|checkNumb',
        'current_date' => 'require|date|checkDate',
        'photo_id' => 'require',
        'staff_id' => 'require',
        'uType1_current_numb' => 'require', //波峰
        'uType2_current_numb' => 'require', //峰
        'uType3_current_numb' => 'require', //谷
        'amount' =>'require' //账单金额

    ];

    protected $message = [
        'em_id.require' => '电表参数错误',
        'last_numb.require' => '上次抄表数不能为空',
        'last_date.require' => '上次查表日期不正确',
        'current_numb.require' => '请填写本次读数',
        'current_date.require' => '请选择本次抄表日期',
        'current_date.date' => '本次抄表日期格式不正确',
        'photo_id.require' => '请上传电表照片',
        'staff_id.require' => '请选择抄表员',
        'uType1_current_numb.require' => '请填写波峰数据',
        'uType2_current_numb.require' => '请填写峰数据',
        'uType3_current_numb.require' => '请填写波谷数据',
        'amount.require' =>'缴费金额未填写'
    ];

    protected $scene = [
        's1' => 'em_id,last_numb,last_date,current_numb,current_date,photo_id,staff_id',
        's2' => 'em_id,photo_id,staff_id,uType1_current_numb,uType2_current_numb,uType3_current_numb',
    ];

    protected  function checkDate($value,$rule,$data=[]){
        $curr = strtotime($value);
        $last = strtotime($data['last_date']);

        return $curr > $last ? true : '本次抄表日期必须大于上次抄表日期';
    }

    protected function checkNumb($value,$rule,$data=[]){
        return $value > $data['last_numb'] ? true : '本次抄表度数必须大于上次抄表度数';
    }

}