<?php
namespace app\em\model;

class Em extends Base
{
    protected $table = 'em';

    public function getInitDateAttr($val){
        return date('Y-m-d H:i:s',$val);
    }
    public function setInitDateAttr($val){
        return strtotime($val);
    }


    //获取电表列表与基站相关信息
    public function getAll($pageConf=['list_rows'=>30]){
        $data = $this
            ->field('em.id,em.em_numb,em.em_type_id,em.create_time,s.station_name,s.original_sp_id,
                                 s.station_sp_code,s.proj_number,s.area_id,r.region_name,o.operator_name,er.pricing_type')
            ->leftJoin(['station_info'=>'s'],'em.station_id = s.station_id')
            ->leftJoin(['region'=>'r'],'s.area_id = r.id')
            ->leftJoin(['operator'=>'o'],'o.operator_id = s.original_sp_id')
            ->leftJoin(['em_rule'=>'er'],'er.em_id=em.id')
            ->with('account')
            ->order('id desc')
            ->paginate($pageConf);
        return $data;
    }

    public function account(){
        return $this->hasOne('em_account','em_id');
    }

    //通过id获取单个电表信息
    public function getEmInfoById($id,$mode=false){
        if($mode === false)
            $em = self::with('rule,dc,photo')->find($id);
        else
            $em = self::with($mode)->find($id);
        return $em;
    }

    /**
     * @param $id
     * @param bool $curr 获取本次抄表记录还是上次抄表记录
     * @return array|mixed|\PDOStatement|string|\think\Model|null
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\ModelNotFoundException
     * @throws \think\exception\DbException
     */
    public function getEmUseageInfoById($id,$curr=false){
        $em = $this->getEmInfoById($id,'type,rule');
        //最后一次抄表记录
        if($curr == false){
            $ue = Useage::order('create_time desc,id desc')->get(['em_id'=>$id]);
        } else {
            $ue = Useage::with('photo')->order('create_time desc,id desc')->get(['em_id'=>$id]);
        }
         //如果没有超过表 不论是峰谷表还是普通表 都是空的
        if(!$ue) {
            //如果不是详情页
            $em->last_date = $em->init_date;
            $em->last_numb = $em->init_numb;

            //如果是峰谷表 初始化
            if($em->rule->pricing_type == 2) {
                $em->last_sum_numb = 0;
                $ulist[] = ['typeName' => '尖峰段', 'last_numb' => 0, 'current_numb' => ''];
                $ulist[] = ['typeName' => '峰段', 'last_numb' => 0, 'current_numb' => ''];
                $ulist[] = ['typeName' => '谷段', 'last_numb' => 0, 'current_numb' => ''];
                $ulist[] = ['typeName' => '平段', 'last_numb' => 0, 'current_numb' => ''];
            } else {
                $ulist[] = ['typeName' => '普通', 'last_numb' => 0, 'current_numb' => ''];
                $em->last_sum_numb = $em->init_numb;
            }
            $em->useage = $ulist;

            //历史抄表
            if($em->rule->settle_type==1){
                $em->is_history = 1;
            }
        } else {
             $em->last_date = $ue->current_date;
             $em->last_sum_numb = $ue->current_sum_numb;
             $fields = 'last_numb,current_numb,price';

            if($em->rule->pricing_type == 2){
                $ulist = UseageDetail
                    ::field('case type 
                        when 1 then "尖峰段" 
                        when 2 then "峰段"
                        when 3 then "谷段" 
                        when 4 then "平段"
                        else "普通" end as typeName
                        ')
                    ->field($fields)
                    ->where(['useage_id'=>$ue->useage_id])->select();

                foreach ($ulist as &$u){
                    $u->last_numb = $u->current_numb;
                    $u->current_numb = '';
                    $u->price = '';
                }

                $em->useage = $ulist;
            }
            $em->photo = $ue->photo;
        }
        return $em;
    }

    //获取电表信息与station信息
    public function getBaseInfo($em_id){
        $data = self::field('em.id,em.em_numb,em.em_type_id,em.rate')
                    ->field('s.station_sp_code,s.station_name')
                    ->field('et.name as typeName')
                    ->leftJoin(['station_info'=>'s'],'s.station_id=em.station_id')
                    ->leftJoin(['em_type'=>'et'],'et.id=em.em_type_id')
                    ->where('em.id','=',$em_id)
                    ->find();
        return $data;
    }

    //关联模型
    public function rule(){
        return $this->hasOne('EmRule','em_id','id');
    }

    public function dc(){
        return $this->belongsTo('Dc','dc_id');
    }

    public function photo(){
        return $this->belongsTo('Receipt','photo_id','id');
    }

    public function type(){
        return $this->belongsTo('EmType','em_type_id','id');
    }
}