<?php
namespace app\admin\validate;
use think\Validate;

class StatementAddValidate extends Validate
{
    protected $rule = [
        'emt_id'=>'require',
        'copy_id'=>'require',
        'photo_id'=>'require',
        'repo_power' => 'require',
        'yd_unit' => 'require',
        'financ_unit' => 'require',
        'recharge' =>'require',
        'power_over' => 'require',
        'financ_pay' => 'require',
    ];

    protected $message = [
        'emt_id.require' => '系统异常,没有找到电表类型参数,请联系管理员',
        'copy_id.require' => '系统异常,没有找到抄表单参数,请联系管理员',
        'photo_id.require' => '请上传抄表单照片',
        'repo_power.require' => '系统异常,未正确计算报移动电量,请联系管理员',
        'yd_unit.require' => '系统异常,未正确计算移动结算单价,请联系管理员',
        'financ_unit.require' => '系统异常,未正确计算财务单价,请联系管理员',
        'recharge.require' => '请填写充值金额',
        'power_over.require' => '请填写电表余额',
        'financ_pay.require' => '请输入财务支出金额或相关属性字段用于系统计算',

    ];

    protected $scene = [
        'common' =>'emt_id, copy_id,photo_id,repo_power,yd_unit,financ_unit,financ_pay',
        'card' =>'emt_id, copy_id,photo_id,repo_power,yd_unit,financ_unit,financ_pay,recharge,power_over',
    ];
}