<?php

namespace app\admin\validate;

use think\Validate;

class LoginValidate extends Validate
{
    protected $rule =   [
        'name'  => 'require|max:50|token',
        'password'=>'require',
        'verify'=>'require'
    ];

    protected $message  =   [
        'name.require' => '名称必须',
        'name.max'     => '名称最多不能超过32个字符',
        'name.token' => '非法的请求,请重新登录',
        'password.require'=>'请填写密码',
         'verify.require'=>'请填写验证码'
    ];
}