<?php
namespace app\admin\validate;
use think\Validate;

class DepartmentValidate extends Validate
{
    protected $rule = [
        'name' => 'require|unique:department',
        'pid' => 'number',
        'sort' => 'number|max:3'
    ];

    protected $message = [
        'name.require' => '部门名称必填',
        'name.unique' => '部门名称已经存在',
        'pid.number' => '上级参数错误',
        'sort.max' => '排序字段不能超过999',
        'sort.number' => '排序字段只能是数字'
    ];
}