<?php


namespace app\admin\model;


class SettleModel extends BaseModel
{
    protected  $table = 'settle';

    public function setSettleDateAttr($value){
        return strtotime($value);
    }

    public function getSettleDateAttr($value){
        return date('Y-m-d',$value);
    }

    public function photo(){
        return $this->belongsTo('ReceiptModel','invoice_fid');
    }

    public static function getSettleByCpId($id){
        $setTemp = self::where(['cp_id'=>$id])->find();

        if(isset($setTemp->invoice_fid) && $setTemp->invoice_fid != ''){
            $settle = self::with('photo')->where(['cp_id'=>$id])->find();
            if($settle){
                $settle->photo_src = ltrim($settle->photo->src,'.');
            }
        } else {
            $settle = $setTemp;
        }

        return $settle;
    }
}