<?php
namespace app\admin\model;

use app\admin\controller\Staff;
use app\station\model\Region;
use app\station\model\BusinessModel;
use think\facade\Session;
use app\station\model\Station;

class ElectricMeter extends BaseModel
{
    protected $table = 'electric_meter';

    public function station(){
        return $this->belongsTo('app\station\model\Station','station_id','id');
    }

    public function list($map=[],$pageConf=['list_rows'=>30]){
        $data = $this
                    ->alias('em')
                    ->field('em.id,em.number,em.create_time,s.station_name,s.original_sp_id,
                                 s.station_sp_code,s.proj_number,s.area_id,r.region_name,o.operator_name')
                    ->leftJoin(['station_info'=>'s'],'em.station_id = s.station_id')
                    ->leftJoin(['region'=>'r'],'s.area_id = r.id')
                    ->leftJoin(['operator'=>'o'],'o.operator_id = s.original_sp_id')
                    ->where($map)
                    ->order('id desc')
                    ->paginate($pageConf);
        return $data;
    }

    public function regions(){
        return Region::field('id,region_name,pid')->select()->toArray();
    }
    public function business(){
        return BusinessModel::field('business_id,business_name,business_state')->where('business_state=1')->select()->toArray();
    }
    public function searchList($map=[],$config = ['list_rows'=>10]){
        $data = $this
            ->alias('em')
            ->field('em.id,em.number,s.station_name,s.original_sp_id,
                          s.station_sp_code,s.proj_number,s.area_id,
                          r.region_name,o.operator_name,er.rent,er.qrcode')
            ->leftJoin(['station_info'=>'s'],'em.station_id = s.station_id')
            ->leftJoin(['region'=>'r'],'s.area_id = r.id')
            ->leftJoin(['operator'=>'o'],'o.operator_id = s.original_sp_id')
            ->leftJoin(['engine_room'=>'er'],'er.id = em.er_id')
            ->where($map)
            ->paginate($config);
        return $data;
    }

    public function getEmById($id){
        $data = $this
            ->alias('em')
            ->field('em.*,s.station_id as sid,s.station_name,s.station_sp_code,s.proj_number,original_sp_id')
            ->field('region.region_name as area_name')
            ->field('r.src as photo_src,rp.src as protocol_src')
            ->field('er.name as er_name,er.position as er_position,
                          er.contact as er_contact,er.tel as er_tel,er.property_position,
                          er.receive,er.rent,er.remark as er_remark,
                          st.name as staff_name,
                          emt.name as emt_name,emt.id as emt_id,
                          c.number as contract_number,c.sign_time as contract_sign_time,c.period as period,
                          p.name as protocol_name,p.number as protocol_number,p.start_time as protocol_start_date,
                          p.end_time as protocol_end_date,p.sign_time as protocol_sign_date,p.remark as protocol_remark,
                          p.file_id as protocol_file_id')
            ->field('operator.operator_name')
            ->leftJoin(['station_info'=>'s'],'s.station_id = em.station_id')
            ->leftJoin(['region'],'region.id = area_id')
            ->leftJoin(['engine_room'=>'er'],'em.er_id = er.id')
            ->leftJoin(['staff'=>'st'],'em.staff_id = st.id')
            ->leftJoin(['electric_meter_type'=>'emt'],'emt.id = em.emt_id')
            ->leftJoin(['contract'=>'c'],'c.id = em.contract_id')
            ->leftJoin(['contract'=>'p'],'p.id = em.protocol_id')
            ->leftJoin(['receipt'=>'r'],'em.photo_id = r.id')
            ->leftJoin(['receipt'=>'rp'],'p.file_id = rp.id')
            ->leftJoin(['operator'],'operator.operator_id = original_sp_id')

            ->find($id)
            ->toArray();

        if(isset($data['photo_src']) && $data['photo_src'] !='')
            $data['photo_src'] = trim($data['photo_src'],'.');
        else
            $data['photo_src'] = '#';
        if(isset($data['protocol_src']) && $data['protocol_src'] !='')
            $data['protocol_src'] = ltrim($data['protocol_src'],'.');
        else
            $data['protocol_src'] = '#';
        return $data;
    }

    public function getEmsBySids($sIds){
        $data = $this
            ->alias('em')
            ->field('em.*,FROM_UNIXTIME(em.first_cp_date, "%Y-%m-%d") as first_cp_date,s.station_id as sid,s.station_name,s.station_sp_code,s.proj_number')
            ->field('CASE WHEN em.is_protocol = "1" THEN "是" ELSE "否" END as isprotocol')
            ->field('er.name as er_name,er.position as er_position,er.qrcode as qrcode,
                          er.contact as er_contact,er.tel as er_tel,er.property_position,
                          er.receive,er.rent,er.remark as er_remark,
                          st.name as staff_name,
                          emt.name as emt_name,emt.id as emt_id,
                          c.number as contract_number,FROM_UNIXTIME(c.sign_time, "%Y-%m-%d") as contract_sign_time,c.period as period,
                          p.name as protocol_name,p.number as protocol_number,FROM_UNIXTIME(p.start_time, "%Y-%m-%d") as protocol_start_date,
                          FROM_UNIXTIME(p.end_time, "%Y-%m-%d") as protocol_end_date,FROM_UNIXTIME(p.sign_time, "%Y-%m-%d") as protocol_sign_date,p.remark as protocol_remark,
                          p.file_id as protocol_file_id')
            ->leftJoin(['station_info'=>'s'],'s.station_id = em.station_id')
            ->leftJoin(['engine_room'=>'er'],'em.er_id = er.id')
            ->leftJoin(['staff'=>'st'],'em.staff_id = st.id')
            ->leftJoin(['electric_meter_type'=>'emt'],'emt.id = em.emt_id')
            ->leftJoin(['contract'=>'c'],'c.id = em.contract_id')
            ->leftJoin(['contract'=>'p'],'p.id = em.protocol_id')
            ->where(function($query) use ($sIds){
                $user = Session::get('user');
                $identity = (new Staff())->getIdentity();
                if(!$user['is_admin'] && $identity!= 5){
                    $query->where('em.station_id','in',$sIds);
                }
            })
            ->where(function($query){
                $map = Session::get('map');
                $query->where($map);
            })
            ->select();
        if($data) return $data->toArray();
    }

    public function getEmIdsBySids($sIds){
        if(empty($sIds)) return '';
        $emIds = ElectricMeter::field('id')
                    ->where(['station_id','in',$sIds])
                    ->select();
        return $emIds;
    }


    public function photo(){
        return $this->belongsTo('ReceiptModel','photo_id','id');
    }

    public function type(){
        return $this->belongsTo('ElectricMeterType','emt_id','id');
    }
  public function getStationID($proj_number){
        $map['proj_number']=$proj_number;
        $data=Station::field('station_id')->where($map)->find();

         return $data ? $data['station_id'] : 0;
    }

       public function getEmtId($emt_id){

            $map['name']=$emt_id;
           
          $data=ElectricMeterType::field('id')->where($map)->find();

         return $data ? $data['id'] : 0;
    }

   public function getStaffId($staff_id){

            $map['name']=$staff_id;
           
          $data=StaffModel::field('id')->where($map)->find();

         return $data ? $data['id'] : 0;
    }

    public function getDepartId($staff_id){

            $map['id']=$staff_id;
           
          $data=StaffModel::field('d_id')->where($map)->find();

         return $data ? $data['d_id'] : '';
    }


    public function getEmList($map,$Nowpage,$limits){
        $data = $this->alias('em')
                    ->field('em.id,em.number,em.create_time,s.station_name,s.original_sp_id,
                                 s.station_sp_code,s.proj_number,s.area_id,r.region_name,o.operator_name')
                    ->leftJoin(['station_info'=>'s'],'em.station_id = s.station_id')
                    ->leftJoin(['region'=>'r'],'s.area_id = r.id')
                    ->leftJoin(['operator'=>'o'],'o.operator_id = s.original_sp_id')
                    ->leftJoin(['engine_room'=>'er'],'em.er_id = er.id')
                    ->where($map)
                    ->page($Nowpage, $limits)
                    ->order('id desc')
                    ->select()
                    ->toarray();
        return $data;
    }
    public function  getEmListCount($map){
       $emcount = $this->alias('em')
                    ->field('em.id,em.number,em.create_time,s.station_name,s.original_sp_id,
                                 s.station_sp_code,s.proj_number,s.area_id,r.region_name,o.operator_name')
                    ->leftJoin(['station_info'=>'s'],'em.station_id = s.station_id')
                    ->leftJoin(['region'=>'r'],'s.area_id = r.id')
                    ->leftJoin(['operator'=>'o'],'o.operator_id = s.original_sp_id')
                    ->leftJoin(['engine_room'=>'er'],'em.er_id = er.id')
                    ->where($map)
                    ->count();
                
         return $emcount;
    }

}