<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-25
 * Time: 20:32
 */

namespace app\admin\model;

class CopyModel extends BaseModel
{
    protected $table = 'copy';

    public function setCurrentTimeAttr($value){
        return strtotime($value);
    }

    public function setBeforeTimeAttr($value){
        return strtotime($value);
    }

    public function getCurrentTimeAttr($value){
        return date('Y-m-d',$value);
    }

    public function getBeforeTimeAttr($value){
        return date('Y-m-d',$value);
    }

    //获取抄表单列表
    public static function list($page = 0,$config=[],$map=[]){
        //过滤数据权限
         $config = !empty($config) ?: [
            'list_rows'=>30,
            'page'=> $page,
            'type'     => '\app\extend\PageLayUi',
            'var_page' => 'page'
        ];
        $data = self::field('s.station_sp_code,s.station_name,em.number as em_number')
                    ->field('copy.id,FROM_UNIXTIME(copy.current_time, "%Y-%m-%d") as cp_date,copy.create_time,copy.photo_id')
                    ->field('statement.photo_id as statement_photo_id')
                    ->field('o.status as cp_status,o.statement_id,o.payment_id,o.settle_id,o.order_id')
                    ->join(['electric_meter'=>'em'],'copy.em_id = em.id')
                    ->leftJoin(['statement'],'statement.copy_id = copy.id')
                    ->leftJoin(['order'=>'o'],'o.cp_id = copy.id')
                    ->join(['station_info'=>'s'],'em.station_id = s.station_id')
                    ->order('copy.id desc,copy.create_time desc')
                    ->where($map)
                    ->paginate($config);
        return $data;
    }
    public function getCopyList($map,$Nowpage,$limits){
         $data = self::field('s.station_sp_code,s.station_name,s.area_id,em.number as em_number')
                    ->field('copy.id,FROM_UNIXTIME(copy.current_time, "%Y-%m-%d") as cp_date,copy.create_time,copy.photo_id')
                    ->field('statement.photo_id as statement_photo_id')
                    ->field('o.status as cp_status,o.statement_id,o.payment_id,o.settle_id,o.order_id')
                    ->join(['electric_meter'=>'em'],'copy.em_id = em.id')
                    ->leftJoin(['statement'],'statement.copy_id = copy.id')
                    ->leftJoin(['order'=>'o'],'o.cp_id = copy.id')
                     ->leftJoin(['engine_room'=>'er'],'em.er_id = er.id')
                    ->join(['station_info'=>'s'],'em.station_id = s.station_id')
                    ->where($map)
                     ->page($Nowpage, $limits)
                    ->order('copy.id desc,copy.create_time desc')
                    ->select()
                    ->toarray();
        return $data;
    }
      public function  getCopyListCount($map){
         $data = self::field('s.station_sp_code,s.station_name,em.number as em_number')
                    ->field('copy.id,FROM_UNIXTIME(copy.current_time, "%Y-%m-%d") as cp_date,copy.create_time,copy.photo_id')
                    ->field('statement.photo_id as statement_photo_id')
                    ->field('o.status as cp_status,o.statement_id,o.payment_id,o.settle_id,o.order_id')
                    ->join(['electric_meter'=>'em'],'copy.em_id = em.id')
                    ->leftJoin(['statement'],'statement.copy_id = copy.id')
                    ->leftJoin(['order'=>'o'],'o.cp_id = copy.id')
                     ->leftJoin(['engine_room'=>'er'],'em.er_id = er.id')
                    ->join(['station_info'=>'s'],'em.station_id = s.station_id')
                    ->where($map)
                    ->count();
        return $data;
      }
    public static function getDetailById($id){
        $data = self::field('copy.*')
                    ->field('em.number as em_number')
                    ->field('emt.name as emt_name,emt.type as emt_type,emt.id as emt_id')
                    ->field('s.station_name,s.station_sp_code')
                    ->field('r.src as photo_src')
                    ->field('staff.name as sname')
                    ->leftJoin(['electric_meter'=>'em'],'em.id = copy.em_id')
                    ->leftJoin(['station_info'=>'s'],'s.station_id = em.station_id')
                    ->leftJoin(['electric_meter_type'=>'emt'],'emt.id = em.emt_id')
                    ->leftJoin(['receipt'=>'r'],'r.id = copy.photo_id')
                    ->leftJoin(['staff'],'staff.id = copy.staff_id')
                    ->where('copy.id','=',$id)
                    ->find()->toArray();
        $data['photo_src'] = ltrim($data['photo_src'],'.');
        $data['before_time'] = $data['current_time'];
        $data['before_number'] = $data['current_number'];
        $data['current_time'] = date('Y-m-d',time());
        return $data;
    }

    public static function getCopyEmInfoByCid($id){
        $data = self::field('copy.*')
            ->field('em.number as em_number,em.multiple,em.unit_price,em.protocol_price,em.emt_id')
            ->field('emt.name as emt_name,emt.type as emt_type')
            ->field('s.station_name,s.station_sp_code')
            ->field('r.src as photo_src,r2.src as em_photo_src')
            ->field('staff.name as sname')
            ->field('o.statement_id')
            ->field('o.id as order_id')
            ->leftJoin(['electric_meter'=>'em'],'em.id = copy.em_id')
            ->leftJoin(['station_info'=>'s'],'s.station_id = em.station_id')
            ->leftJoin(['electric_meter_type'=>'emt'],'emt.id = em.emt_id')
            ->leftJoin(['receipt'=>'r'],'r.id = copy.photo_id')
            ->leftJoin(['receipt'=>'r2'],'r2.id = em.photo_id')
            ->leftJoin(['staff'],'staff.id = copy.staff_id')
            ->leftJoin(['order'=>'o'],'o.cp_id = copy.id')
            ->where('copy.id','=',$id)
            ->find()->toArray();

        //获取图片
        $data['photo_src'] = isset($data['photo_src']) ? ltrim($data['photo_src'],'.') : '';
        $data['em_photo_src'] = isset($data['em_photo_src']) ? ltrim($data['em_photo_src'],'.') : '';

        //上期表数1235
        $history = CopyModel::where('em_id','=',$data['em_id'])->order('current_time desc')->select();

        if($history) $history = $history->toArray();
        $count = count($history);

        if($history[$count-1]['id'] == $id || $count <= 1){
            $em = ElectricMeter::find($data['em_id'])->toArray();
            $data['before_number'] = $em['init_degree'];
            $data['before_time'] = date('Y-m-d',$em['first_cp_date']);
        } else {
            foreach ($history as $key=> $value){
                if($value['id'] == $id){
                    $last = $history[$key + 1];
                    break;
                }
            }
            $data['before_number'] = $last['current_number'];
            $data['before_time'] = $last['current_time'];
        }

        //报移动电量
        $data['repo_power'] = $data['current_number'] - $data['before_number'];

        //移动单价
        $data['yd_unit'] = $data['protocol_price'] ?: '1.123';


        //如果是插卡表,则获取上一次的充值金额
        if($data['emt_id'] == 2 || $data['emt_id'] == 4){
            $data['last_power_over'] = StatementModel::getLastPowerOver($data['em_id'],$id);
            $data['last_recharge'] = StatementModel::getLastRecharge($data['em_id'],$id);
        }

        //获取财务支出金额
        $data['financ_pay'] = StatementModel::getFinancPay($id);
        return $data;
    }

    public static function getCopyByEmId($id,$limit = 10){
        $data = self::field('copy.*')
                    ->field('staff.name as sname')
                    ->field('order.payment_status,order.settle_status')
                    ->leftJoin('staff','staff.id = copy.staff_id')
                    ->leftJoin('order','order.cp_id = copy.id')
                    ->where('copy.em_id','=',$id)
                    ->order('copy.current_time asc, copy.id asc')
                    ->limit($limit)
                    ->select();

        //没有找到抄表单
        if($data) $data = $data->toArray();
        if(empty($data)) return [];


        //获取所有记录中的最小时间
        $minDate = strtotime($data[0]['create_time']);
        $minYear = getdate($minDate);
        $minYear = $minYear['year'];

        $currYear = getdate()['year'];
        //年代范围
        $yearRange = $currYear - $minYear;

        //电表初始度数
        $em_init_degree = ElectricMeter::field('init_degree')->get($id)->toArray();

        foreach ($data as $key => $value){
            //判断年限  只有今年数据
            if($yearRange == 0){
                if($key < 10) {
                    $data[$key]['times'] = $currYear . '0' . $key;
                } else {
                    $data[$key]['times'] = $currYear .''. $key;
                }
            } else {
                //要判断该数据是第n年的第几次

                //找到所属年份 与 对应年份的记录
            }


            if($data[$key]['payment_status'] == 1){
                $data[$key]['payment_status'] = '已缴费';
            } else {
                $data[$key]['payment_status'] = '未缴费';
            }

            if($data[$key]['settle_status'] == 1){
                $data[$key]['settle_status'] = '已结算';
            } else {
                $data[$key]['settle_status'] = '未结算';
            }

            if( isset($data[$key-1])) {
                $data[$key]['used_number'] = $data[$key]['current_number'] - $data[$key-1]['current_number'];
                $data[$key]['before_time'] = $data[$key-1]['current_time'];
                $data[$key]['before_number'] = $data[$key-1]['current_number'];
            } else {
                $data[$key]['used_number'] = $data[$key]['current_number'] - $em_init_degree['init_degree'];
                $em = ElectricMeter::find($data[$key]['em_id']);
                $data[$key]['before_time'] = date('Y-m-d',$em->first_cp_date);
                $data[$key]['before_number'] = $em->init_degree;
            }
        }
        return $data;
    }
}