<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-10
 * Time: 19:33
 */

namespace app\admin\controller;

use app\admin\model\DepartmentModel;
use app\admin\model\StaffModel;
use app\station\controller\Search;
use app\station\model\Station as StationModel;
use think\App;
use think\facade\Session;

class Station extends Base
{
    private $search = '';

    public function __construct(App $app = null)
    {
        $this->search = new Search;
        parent::__construct($app);
    }

    public function selectStationByTag(){
        $tag = $this->request->post('seach_type');
        $val = $this->request->post('search_text');

 //        $user = Session::get('user');
 //        $staff = StaffModel::get($user['user_id']);
 //        //通过员工的部门id查询 员工所在部门以及下属部门的所有基站数据


 //        if($user['is_admin']){
 //            $dids = [];
 //            $temp =  DepartmentModel::field('id')->select();
 //            foreach ($temp as $v){
 //                $dids[] = $v['id'];
 //            }
 //        } else {
 //            $dids = (new DepartmentModel)->getNodeIds($staff->d_id);
 //        }
         // $stations = StationModel::field('station_id')
         //    ->where('department_id','in',$dids)
         //    ->select()
         //    ->toArray();
         //权限检测
        $map=[];
                $user = Session::get('user');
                if(!$user['is_admin']){
                    $permissionData=check_data();
                    if($permissionData){
                    $map[]=$permissionData; 
                    }
                }

        $stations = StationModel::field('station_id')
            ->where($map)
            ->select()
            ->toArray();
        $stationArr = [];
        foreach ($stations as $station){
            $stationArr[]= $station['station_id'];
        }

        $stations =  $this->search->searchByTagName($tag,$val,$stationArr);
        if(!$stations){
            return jsonErr('没有查询到与 '.$val.' 有关的信息');
        }
        //不提供二维码查询
//        foreach ($stations as $key => $station){
//            if(empty($station['engine_room']) || !isset($station['engine_room']['qrcode'])){
//                $stations[$key]['engine_room']['qrcode'] = 'null';
//            }
//        }

        return jsonSuc('ok',$stations);
    }

    public function getStationById($id){
        return StationModel::field('station_id,station_name,station_sp_code,proj_number,original_sp_id')
                            ->field('region.region_name as area_name')
                            ->field('operator.operator_name')
                            ->leftJoin(['operator'],'operator.operator_id = original_sp_id')
                            ->leftJoin(['region'],'region.id=area_id')
                            ->get(['station_id'=>$id]);
    }
}