<?php
/**
 * Created by PhpStorm.
 * User: chouchou
 * Date: 2019-6-25
 * Time: 23:29
 */

namespace app\admin\controller;

//结算单控制器
use app\admin\model\CopyModel;
use app\admin\model\OrderModel;
use app\admin\model\SettleModel;
use app\admin\model\StaffModel;
use app\admin\model\StatementModel;
use app\admin\validate\SettleAddValidate;
use think\facade\Request;

class Settle extends Base
{
    public function create($cp_id){
        $users = StaffModel::getStaffsDepartmentCurrent();
        $copy = CopyModel::getCopyEmInfoByCid($cp_id);
        $statement = StatementModel::order('id desc')->get(['copy_id'=>$cp_id]);
        if($statement)
            if($statement->yd_unit != '' &&  $statement->repo_power !='')
                $copy['amount'] = $statement->yd_unit * $statement->repo_power;
            else
                $copy['amount'] = '';
        else
            $copy['amount'] = '';

        //身份信息
        $identity = (new Staff)->getIdentity();
        $this->assign('iden',$identity);

        $settle = SettleModel::getSettleByCpId($cp_id);

        if($settle && $settle->settle_sid){
            $users = StaffModel::getStaffsByDepartment($settle->settle_sid);
        }

        //如果是修改则找到提交人
        if(($settle && $settle->settle_sid > 1)){
            $users = StaffModel::getStaffsByDepartment($settle->settle_sid);
        }
        if($identity != 5){
            $users = [];
        }

        $order = OrderModel::get(['cp_id'=>$cp_id]);
        $this->assign('order',$order);
        $this->assign('settle',$settle);
        $this->assign('users',$users);
        $this->assign('copy',$copy);
        return $this->fetch('add');
    }

    public function upInvoice(){
        $file = Request::file('invoice_photo');
        $upload = new Upload($file,1);
        $result = $upload->upload();

        if($result){
            return jsonSuc('发票附件上传成功',$result);
        } else {
            return jsonErr($result);
        }
    }

    public function store(){
        $data = Request::post();
        $validate = new settleAddValidate();
        $identity = (new Staff)->getIdentity();

        if($identity == 5){
            if(!$validate->scene('finance')->check($data)){
                return jsonErr($validate->getError());
            }
        } else {
            if(!$validate->scene('staff')->check($data)){
                return jsonErr($validate->getError());
            }
        }

        if($data['settle_id']){
            $settle = SettleModel::find($data['settle_id']);
            $settle->invoice_numb = $data['invoice_numb'];
            $settle->invoice_fid = $data['invoice_fid'];
            $settle->settle_sid = $data['settle_sid'];

            if($settle->save()){
                $order = OrderModel::get(['settle_id'=>$data['settle_id']]);
                if($settle->invoice_numb !='' && $settle->invoice_fid!='' && $settle->settle_sid){
                    $order->settle_status = 1;
                    $order->save();
                }
                return jsonSuc('更新结算信息成功');
            } else {
                return jsonErr('更新结算信息失败');
            }
        } else {
            $settle = settleModel::create($data);
            $order = OrderModel::order('id desc')->get(['cp_id'=>$data['cp_id']]);
            $order->settle_id = $settle->id;
            if($order->save()){
                return jsonSuc('保存结算信息成功');
            } else {
                return jsonErr('更新订单信息失败');
            }
        }
    }
}