<?php
namespace app\admin\controller;

use app\admin\model\NavModel;
use app\admin\model\StaffRoleModel;

/**
 * 后台首页
 * Class Index
 * @package app\admin\controller
 */
class Index extends Base
{
    public function index()
    {
        $user = session('user');

        if($user['is_admin']){
            $navData = (new NavModel())->getNavs();
        } else {
            //查询菜单权限
            $roles = StaffRoleModel::getStaffRolesById($user['user_id']);

            $navData = (new NavModel())->getNavs($roles);
        }

        $this->assign('nav',$navData);
        $this->assign('user', $user);
        return $this->fetch('index');
    }
}
