<?php
namespace app\station\controller\v1;
use app\station\model\OperatorModel;
use think\Controller;
/**
 * 运营商API接口控制器
 * 负责运营商的增删改查
 * Class Region
 * @package app\station\controller
 */
class Operator extends Controller
{
    /**
 * 基站运营商数据列表
 */
    public function operator_list()
    {
    	  $model=new OperatorModel;
    	  $data=$model->selectOperatorList();
          if($data['code']==200){
             if($data['data']){
               return jsonSucc('','suceeess',$data['data']);
             }else{
               return jsonSucc('20065','Business line data does not exist');
             }
          }else{
               return jsonSucc('20063','Query error please try again');
          }
    	  
    }
/**
 * 添加基站运营商
 */
      public function operator_add()
    {
    	$parem=$this->request->post();
    	if($parem){
    	 $model=new OperatorModel;
    	 $result=$model->insertOperator($parem);
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 修改基站运营商
 */
     public function operator_edit()
    {
    	 $parem=$this->request->post();
    	if($parem){
         if(empty($parem['operator_id'])){
            return jsonSucc('200001','参数不合法，无法修改');
         }
    	 $model=new OperatorModel;
    	 $result=$model->updOperator($parem);
    	 if($result['code']==10001){
    	 	return jsonSucc('200001','id不存在');
    	 }
    	 if($result['code']==200){
           return jsonSucc('200','suceess');
    	 }else{
    	   return jsonSucc('200001','error');
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
/**
 * 获取修改基站运营商数据
 */
    public function geteditoperator()
    {
    	$parem=$this->request->post();
    	 $model=new OperatorModel;
    	 $result=$model->updselectOperator($parem);
    	  if($result['code']==10001){
    	  	return jsonSucc('200001','暂无找到id');
    	  }else{
    	  	 return jsonSucc('','suceess',$result['data']);
    	  }
    	 
    }
/**
 * 删除运营商数据（软删除）
 */
     public function operator_del()
    { 
      $parem=$this->request->post();
    	if($parem){
    	 $model=new OperatorModel;
    	 $result=$model->delOperator($parem);
    	 switch ($result['code']) {
    	 	case '10001':
    	 		 return jsonSucc('200001','暂无找到id');
    	 		break;
    	 	
    	 	case '200':
    	 		 return jsonSucc('200','suceess');
    	 		break;

    	 	default:
    	 		return jsonSucc('1000001','error');
    	 		break;
    	 }
    	}else{
    		return jsonSucc('1000001','error');
    	}
    }
}